/*
 * Decompiled with CFR 0.152.
 */
package com.gravestone.gravecore.ability;

import com.gravestone.gravecore.ability.CoreAbilities;
import com.gravestone.gravecore.ability.ForceFieldAbility;
import com.gravestone.gravecore.ability.PotionPunchAbility;
import com.gravestone.gravecore.entity.CoreAttributes;
import java.util.concurrent.atomic.AtomicReference;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.threetag.palladium.power.ability.Ability;
import net.threetag.palladium.power.ability.AbilityInstance;
import net.threetag.palladium.power.ability.AbilityUtil;
import net.threetag.palladium.util.PlayerUtil;
import net.threetag.palladiumcore.event.EventResult;
import net.threetag.palladiumcore.event.LivingEntityEvents;

public class CoreAbilityEventHandler
implements LivingEntityEvents.Hurt,
LivingEntityEvents.Attack {
    public static void init() {
        CoreAbilityEventHandler handler = new CoreAbilityEventHandler();
        LivingEntityEvents.ATTACK.register((Object)handler);
        LivingEntityEvents.HURT.register((Object)handler);
    }

    public EventResult livingEntityAttack(LivingEntity entity, DamageSource damageSource, float amount) {
        LivingEntity sourceEntity;
        Entity entity2 = damageSource.m_7639_();
        if (entity2 instanceof LivingEntity && !AbilityUtil.getEnabledEntries((LivingEntity)(sourceEntity = (LivingEntity)entity2), (Ability)((Ability)CoreAbilities.POTIONPUNCH.get())).isEmpty()) {
            for (AbilityInstance entry : AbilityUtil.getEnabledInstances((LivingEntity)sourceEntity, (Ability)((Ability)CoreAbilities.POTIONPUNCH.get()))) {
                int time = Math.max((Integer)entry.getProperty(PotionPunchAbility.TIME), 0) * 20;
                entity.m_7292_(new MobEffectInstance((MobEffect)entry.getProperty(PotionPunchAbility.EFFECT), time));
            }
        }
        if (!AbilityUtil.getEnabledEntries((LivingEntity)entity, (Ability)((Ability)CoreAbilities.FORCEFIELD.get())).isEmpty()) {
            for (AbilityInstance entry : AbilityUtil.getEnabledInstances((LivingEntity)entity, (Ability)((Ability)CoreAbilities.FORCEFIELD.get()))) {
                if (!ForceFieldAbility.isImmuneAgainst(entry, damageSource)) continue;
                int helth = (Integer)entry.getProperty(ForceFieldAbility.MAXHEALTH);
                int helf = (Integer)entry.getProperty(ForceFieldAbility.HEALTH);
                boolean thorny = (Boolean)entry.getProperty(ForceFieldAbility.THORNS);
                if (helf <= 0) continue;
                if (thorny) {
                    DamageSource damageSource2;
                    if (entity instanceof Player) {
                        Player player = (Player)entity;
                        damageSource2 = entity.m_9236_().m_269111_().m_269075_(player);
                    } else {
                        damageSource2 = entity.m_269291_().m_269333_(entity);
                    }
                    DamageSource damageSrc = damageSource2;
                    damageSource.m_7639_().m_6469_(damageSrc, amount);
                }
                int newhelf = (int)((float)helf - amount);
                entry.setUniqueProperty(ForceFieldAbility.HEALTH, (Object)newhelf);
                PlayerUtil.playSoundToAll((Level)entity.m_9236_(), (double)entity.m_20185_(), (double)entity.m_20188_(), (double)entity.m_20189_(), (double)100.0, (ResourceLocation)((ResourceLocation)entry.getProperty(ForceFieldAbility.SOUND)), (SoundSource)entity.m_5720_(), (float)1.0f, (float)1.0f);
                return EventResult.cancel();
            }
        }
        return this.livingEntityHurt(entity, damageSource, new AtomicReference<Float>(Float.valueOf(amount)));
    }

    public EventResult livingEntityHurt(LivingEntity entity, DamageSource damageSource, AtomicReference<Float> amount) {
        if (damageSource.m_276093_(DamageTypes.f_268671_) && entity.m_21204_().m_22171_((Attribute)CoreAttributes.FALL_RESISTANCE.get())) {
            float distance;
            double resistance = entity.m_21133_((Attribute)CoreAttributes.FALL_RESISTANCE.get());
            if (resistance > (double)(distance = entity.f_19789_)) {
                return EventResult.cancel();
            }
            amount.set(Float.valueOf((float)((double)amount.get().floatValue() - (resistance - 3.0))));
        }
        if (amount.get().floatValue() == 0.0f) {
            return EventResult.cancel();
        }
        return EventResult.pass();
    }
}

