/*
 * Decompiled with CFR 0.152.
 */
package com.gravestone.gravecore.ability;

import java.util.Comparator;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.threetag.palladium.power.IPowerHolder;
import net.threetag.palladium.power.ability.Ability;
import net.threetag.palladium.power.ability.AbilityInstance;
import net.threetag.palladium.util.ScoreboardUtil;
import net.threetag.palladium.util.icon.ItemIcon;
import net.threetag.palladium.util.property.AttributeProperty;
import net.threetag.palladium.util.property.DoubleProperty;
import net.threetag.palladium.util.property.IntegerProperty;
import net.threetag.palladium.util.property.PalladiumProperty;
import net.threetag.palladium.util.property.StringProperty;
import net.threetag.palladium.util.property.UUIDProperty;

public class DynamicAttributeAbility
extends Ability {
    public static final PalladiumProperty<String> SCOREBOARD = new StringProperty("scoreboard").configurable("Scoreboard Name.");
    public static final PalladiumProperty<Attribute> ATTRIBUTE = new AttributeProperty("attribute").configurable("Determines which attribute should be modified. Possible attributes: " + DynamicAttributeAbility.getAttributeList());
    public static final PalladiumProperty<Double> AMOUNT = new DoubleProperty("division_amount").configurable("The amount the scoreboard value will be divided by");
    public static final PalladiumProperty<Integer> OPERATION = new IntegerProperty("operation").configurable("The operation for the giving attribute modifier (More: https://minecraft.gamepedia.com/Attribute#Operations)");
    public static final PalladiumProperty<UUID> UUID = new UUIDProperty("uuid").configurable("Sets the unique identifier for this attribute modifier. If not specified it will generate a random one");

    public DynamicAttributeAbility() {
        this.withProperty(ICON, new ItemIcon((ItemLike)Items.f_42469_));
        this.withProperty(SCOREBOARD, "Score.Board");
        this.withProperty(ATTRIBUTE, Attributes.f_22284_);
        this.withProperty(AMOUNT, 1.0);
        this.withProperty(OPERATION, 0);
        this.withProperty(UUID, java.util.UUID.fromString("498be4fb-af04-42f2-8948-e6ccdc0d99e1"));
    }

    public void tick(LivingEntity entity, AbilityInstance entry, IPowerHolder holder, boolean enabled) {
        if (enabled) {
            Attribute attribute = (Attribute)entry.getProperty(ATTRIBUTE);
            AttributeInstance instance = entity.m_21051_(attribute);
            if (instance == null || entity.m_9236_().f_46443_) {
                return;
            }
            double dascore = (double)ScoreboardUtil.getScore((Entity)entity, (String)((String)entry.getProperty(SCOREBOARD)), (int)1) / (Double)entry.getProperty(AMOUNT);
            UUID uuid = (UUID)entry.getProperty(UUID);
            AttributeModifier modifier = instance.m_22111_(uuid);
            if (modifier != null && (modifier.m_22218_() != dascore || modifier.m_22217_().m_22235_() != ((Integer)entry.getProperty(OPERATION)).intValue())) {
                instance.m_22120_(uuid);
                modifier = null;
            }
            if (modifier == null) {
                modifier = new AttributeModifier(uuid, entry.getConfiguration().getDisplayName().getString(), dascore, AttributeModifier.Operation.m_22236_((int)((Integer)entry.getProperty(OPERATION))));
                instance.m_22118_(modifier);
            }
        } else {
            this.lastTick(entity, entry, holder, false);
        }
    }

    public void lastTick(LivingEntity entity, AbilityInstance entry, IPowerHolder holder, boolean enabled) {
        if (entity.m_21051_((Attribute)entry.getProperty(ATTRIBUTE)) != null && entity.m_21051_((Attribute)entry.getProperty(ATTRIBUTE)).m_22111_((UUID)entry.getProperty(UUID)) != null) {
            entity.m_21051_((Attribute)entry.getProperty(ATTRIBUTE)).m_22120_((UUID)entry.getProperty(UUID));
        }
    }

    public static String getAttributeList() {
        return BuiltInRegistries.f_256951_.m_6566_().stream().map(ResourceLocation::toString).sorted(Comparator.naturalOrder()).collect(Collectors.joining(", "));
    }

    public String getDocumentationDescription() {
        return "Adds an attribute modifier to the entity while the ability is enabled that is entirely configurable via a scoreboard.";
    }
}

