/*
 * Decompiled with CFR 0.152.
 */
package com.gravestone.gravecore.ability;

import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundExplodePacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.phys.Vec3;
import net.threetag.palladium.power.IPowerHolder;
import net.threetag.palladium.power.ability.Ability;
import net.threetag.palladium.power.ability.AbilityInstance;
import net.threetag.palladium.util.icon.ItemIcon;
import net.threetag.palladium.util.property.BooleanProperty;
import net.threetag.palladium.util.property.IntegerProperty;
import net.threetag.palladium.util.property.PalladiumProperty;

public class ExplodeAbility
extends Ability {
    public static final PalladiumProperty<Integer> EXPLODE = new IntegerProperty("explosion").configurable("the scale of the explosion.");
    public static final PalladiumProperty<Boolean> FIRE = new BooleanProperty("fire").configurable("does it set things on fire?");

    public ExplodeAbility() {
        this.withProperty(ICON, new ItemIcon((ItemLike)Items.f_42613_));
        this.withProperty(EXPLODE, 10);
        this.withProperty(FIRE, false);
    }

    public void tick(LivingEntity entity, AbilityInstance entry, IPowerHolder holder, boolean enabled) {
        if (enabled && !entity.m_9236_().f_46443_) {
            Boolean fire = (Boolean)entry.getProperty(FIRE);
            int boom = (Integer)entry.getProperty(EXPLODE);
            Explosion explosion = new Explosion(entity.m_9236_(), (Entity)entity, entity.m_20185_(), entity.m_20188_(), entity.m_20189_(), (float)boom, fire.booleanValue(), Explosion.BlockInteraction.DESTROY);
            explosion.m_46061_();
            explosion.m_46075_(true);
            if (!explosion.m_254884_()) {
                explosion.m_46080_();
            }
            for (Player player : entity.m_9236_().m_6907_()) {
                if (!(player.m_20275_(entity.m_20185_(), entity.m_20188_(), entity.m_20189_()) < 4096.0) || !(player instanceof ServerPlayer)) continue;
                ServerPlayer serverPlayer = (ServerPlayer)player;
                serverPlayer.f_8906_.m_9829_((Packet)new ClientboundExplodePacket(entity.m_20185_(), entity.m_20188_(), entity.m_20189_(), (float)boom, explosion.m_46081_(), (Vec3)explosion.m_46078_().get(serverPlayer)));
            }
        }
    }

    public String getDocumentationDescription() {
        return "he brings the boom.";
    }
}

