/*
 * Decompiled with CFR 0.152.
 */
package com.gravestone.gravecore.ability;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.threetag.palladium.power.IPowerHolder;
import net.threetag.palladium.power.ability.Ability;
import net.threetag.palladium.power.ability.AbilityInstance;
import net.threetag.palladium.util.ScoreboardUtil;
import net.threetag.palladium.util.icon.ItemIcon;
import net.threetag.palladium.util.property.BooleanProperty;
import net.threetag.palladium.util.property.IntegerProperty;
import net.threetag.palladium.util.property.PalladiumProperty;
import net.threetag.palladium.util.property.PropertyManager;
import net.threetag.palladium.util.property.ResourceLocationProperty;
import net.threetag.palladium.util.property.StringProperty;
import net.threetag.palladium.util.property.SyncType;
import net.threetag.palladium.util.property.TagKeyListProperty;

public class ForceFieldAbility
extends Ability {
    public static final PalladiumProperty<Integer> MAXHEALTH = new IntegerProperty("max_health").configurable("sets the max health of the shield.");
    public static final PalladiumProperty<Integer> REGEN = new IntegerProperty("regen_rate").configurable("how many ticks it takes to regenerate 1 health.");
    public static final PalladiumProperty<ResourceLocation> SOUND = new ResourceLocationProperty("sound").configurable("Sound ID that is played when a block is successful");
    public static final PalladiumProperty<String> SCOREBOARD = new StringProperty("scoreboard").configurable("optional output for shield health to a scoreboard.");
    public static final PalladiumProperty<List<TagKey<DamageType>>> DAMAGE_SOURCES = new TagKeyListProperty("damage_sources", Registries.f_268580_).configurable("Determines which damage sources have no effect on the entity based on a tag. Minecraft's builtin damage source tags: " + Arrays.toString(ForceFieldAbility.getExampleTags().stream().map(t -> t.f_203868_().toString()).toArray()));
    public static final PalladiumProperty<Boolean> THORNS = new BooleanProperty("thorns").configurable("Decides of the power deals damage back to the opponent");
    public static final PalladiumProperty<Integer> HEALTH = new IntegerProperty("Health").sync(SyncType.NONE);

    public ForceFieldAbility() {
        this.withProperty(ICON, new ItemIcon((ItemLike)Items.f_42469_));
        this.withProperty(SOUND, new ResourceLocation("item.shield.block"));
        this.withProperty(MAXHEALTH, 100);
        this.withProperty(SCOREBOARD, null);
        this.withProperty(REGEN, 20);
        this.withProperty(DAMAGE_SOURCES, Arrays.asList(DamageTypeTags.f_268725_, DamageTypeTags.f_268549_));
        this.withProperty(THORNS, false);
    }

    public void registerUniqueProperties(PropertyManager manager) {
        manager.register(HEALTH, (Object)100);
    }

    public void firstTick(LivingEntity entity, AbilityInstance entry, IPowerHolder holder, boolean enabled) {
        if (enabled) {
            // empty if block
        }
    }

    public void tick(LivingEntity entity, AbilityInstance entry, IPowerHolder holder, boolean enabled) {
        if (!enabled) {
            int helth = (Integer)entry.getProperty(MAXHEALTH);
            int helf = (Integer)entry.getProperty(HEALTH);
            int regen = (Integer)entry.getProperty(REGEN);
            if (helf < helth && entity.f_19797_ % regen == 0) {
                entry.setUniqueProperty(HEALTH, (Object)(helf + 1));
            }
        }
        if (entry.getProperty(SCOREBOARD) != null) {
            ScoreboardUtil.setScore((Entity)entity, (String)((String)entry.getProperty(SCOREBOARD)), (int)((Integer)entry.getProperty(HEALTH)));
        }
    }

    public static boolean isImmuneAgainst(AbilityInstance entry, DamageSource source) {
        if (!entry.isEnabled()) {
            return false;
        }
        for (TagKey tag : (List)entry.getProperty(DAMAGE_SOURCES)) {
            if (!source.m_269533_(tag)) continue;
            return true;
        }
        return false;
    }

    public String getDocumentationDescription() {
        return "makes a forcefeild around the player that deflects damage.";
    }

    public static List<TagKey<?>> getExampleTags() {
        Field[] allFields;
        ArrayList list = new ArrayList();
        for (Field field : allFields = DamageTypeTags.class.getDeclaredFields()) {
            try {
                Object object = field.get(null);
                if (!(object instanceof TagKey)) continue;
                TagKey tag = (TagKey)object;
                list.add(tag);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }
        return list;
    }
}

