/*
 * Decompiled with CFR 0.152.
 */
package com.gravestone.gravecore.ability;

import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetEntityMotionPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.phys.Vec3;
import net.threetag.palladium.power.IPowerHolder;
import net.threetag.palladium.power.ability.Ability;
import net.threetag.palladium.power.ability.AbilityInstance;
import net.threetag.palladium.util.icon.ItemIcon;
import net.threetag.palladium.util.property.DoubleProperty;
import net.threetag.palladium.util.property.PalladiumProperty;
import net.threetag.palladium.util.property.StringProperty;

public class MomentumAbility
extends Ability {
    public static final PalladiumProperty<Double> MOTION_SCALE = new DoubleProperty("motion_scale").configurable("the speed you move.");
    public static final PalladiumProperty<String> DIRECTION = new StringProperty("direction").configurable("[ backward, left, right, up, down, forward, facing ]. pick the direction you are going.");

    public MomentumAbility() {
        this.withProperty(ICON, new ItemIcon((ItemLike)Items.f_42613_));
        this.withProperty(MOTION_SCALE, 1.1);
        this.withProperty(DIRECTION, "forward");
    }

    public void tick(LivingEntity entity, AbilityInstance entry, IPowerHolder holder, boolean enabled) {
        if (!enabled) {
            return;
        }
        double scale = (Double)entry.getProperty(MOTION_SCALE);
        String direction = ((String)entry.getProperty(DIRECTION)).toLowerCase();
        Vec3 look = entity.m_20154_();
        Vec3 up = entity.m_20289_(1.0f);
        Vec3 forwardDir = look.m_82542_(1.0, 0.0, 1.0).m_82541_();
        Vec3 rightDir = forwardDir.m_82537_(up).m_82541_();
        Vec3 motion = switch (direction) {
            case "backward" -> forwardDir.m_82490_(-1.0);
            case "left" -> rightDir.m_82490_(-1.0);
            case "right" -> rightDir;
            default -> forwardDir;
        };
        Vec3 down = up.m_82490_(-1.0);
        if (direction.equals("up")) {
            entity.m_246865_(up);
        } else if (direction.equals("down")) {
            entity.m_246865_(down);
        } else if (direction.equals("facing")) {
            Vec3 SEE = entity.m_20154_().m_82490_(scale);
            entity.m_20256_(SEE);
        } else {
            entity.m_246865_(motion.m_82490_(scale));
        }
        if (entity instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)entity;
            serverPlayer.f_8906_.m_9829_((Packet)new ClientboundSetEntityMotionPacket((Entity)entity));
        }
    }

    public String getDocumentationDescription() {
        return "Pushes the entity in a set direction.";
    }
}

