/*
 * Decompiled with CFR 0.152.
 */
package com.gravestone.gravecore.ability;

import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.threetag.palladium.entity.CustomProjectile;
import net.threetag.palladium.power.IPowerHolder;
import net.threetag.palladium.power.ability.Ability;
import net.threetag.palladium.power.ability.AbilityInstance;
import net.threetag.palladium.util.icon.ItemIcon;
import net.threetag.palladium.util.property.ArmTypeProperty;
import net.threetag.palladium.util.property.BooleanProperty;
import net.threetag.palladium.util.property.CompoundTagProperty;
import net.threetag.palladium.util.property.EntityTypeProperty;
import net.threetag.palladium.util.property.FloatProperty;
import net.threetag.palladium.util.property.PalladiumProperty;

public class ProjectileAbility
extends Ability {
    public static final PalladiumProperty<EntityType<?>> ENTITY_TYPE = new EntityTypeProperty("entity_type").configurable("Entity type ID for the projectile entity");
    public static final PalladiumProperty<CompoundTag> ENTITY_DATA = new CompoundTagProperty("entity_data").configurable("Entity NBT data");
    public static final PalladiumProperty<Float> INACCURACY = new FloatProperty("inaccuracy").configurable("Determines the inaccuracy when shooting the projectile");
    public static final PalladiumProperty<Float> VELOCITY = new FloatProperty("velocity").configurable("Determines the velocity when shooting the projectile");
    public static final PalladiumProperty<Float> YAW_OFFSET = new FloatProperty("yawOffset").configurable("the value offset for the yaw from the body");
    public static final PalladiumProperty<Float> PITCH_OFFSET = new FloatProperty("pitchOffset").configurable("the value offset for the pitch from the body");
    public static final PalladiumProperty<ArmTypeProperty.ArmType> SWINGING_ARM = new ArmTypeProperty("swinging_arm").configurable("Determines which arm(s) should swing upon shooting");
    public static final PalladiumProperty<Boolean> DAMAGE_FROM_PLAYER = new BooleanProperty("damage_from_player").configurable("If this is set to true and a custom projectile is used, the damage will automatically be set the player damage value");
    public static final PalladiumProperty<Boolean> IGNORE_PLAYER_MOVEMENT = new BooleanProperty("ignore_player_movement").configurable("If this is set to true and you shoot a projectile, your player's movement will NOT be added to it. Having the player movement be added is default default vanilla behaviour");

    public ProjectileAbility() {
        this.withProperty(ICON, new ItemIcon((ItemLike)Items.f_42452_));
        this.withProperty(ENTITY_TYPE, EntityType.f_20477_);
        this.withProperty(ENTITY_DATA, null);
        this.withProperty(INACCURACY, Float.valueOf(0.0f));
        this.withProperty(VELOCITY, Float.valueOf(1.5f));
        this.withProperty(YAW_OFFSET, Float.valueOf(-20.0f));
        this.withProperty(PITCH_OFFSET, Float.valueOf(25.0f));
        this.withProperty(SWINGING_ARM, ArmTypeProperty.ArmType.MAIN_ARM);
        this.withProperty(DAMAGE_FROM_PLAYER, false);
        this.withProperty(IGNORE_PLAYER_MOVEMENT, false);
    }

    public void tick(LivingEntity entity, AbilityInstance entry, IPowerHolder holder, boolean enabled) {
        if (!entity.m_9236_().f_46443_ && enabled) {
            CompoundTag compound = (CompoundTag)entry.getProperty(ENTITY_DATA);
            compound = compound == null ? new CompoundTag() : compound;
            compound.m_128359_("id", BuiltInRegistries.f_256780_.m_7981_((Object)((EntityType)entry.getProperty(ENTITY_TYPE))).toString());
            ServerLevel world = (ServerLevel)entity.m_9236_();
            EntityType.m_20645_((CompoundTag)compound, (Level)world, en -> {
                if (!(en instanceof Projectile)) {
                    return null;
                }
                Projectile projectile = (Projectile)en;
                float inaccuracy = ((Float)entry.getProperty(INACCURACY)).floatValue();
                double alt_inacc = Math.random() * 2.0 * (double)inaccuracy - (double)inaccuracy;
                float pitch = -ProjectileAbility.toRadians(Float.valueOf((float)((double)(entity.m_146909_() + ((Float)entry.getProperty(PITCH_OFFSET)).floatValue()) + alt_inacc)));
                float yaw = -ProjectileAbility.toRadians(Float.valueOf((float)((double)(entity.m_146908_() + ((Float)entry.getProperty(YAW_OFFSET)).floatValue()) + alt_inacc)));
                double x = entity.m_20185_() + Math.cos(pitch) * Math.sin(yaw);
                double y = entity.m_20186_() + (double)entity.m_20192_() + Math.sin(pitch);
                double z = entity.m_20189_() + Math.cos(pitch) * Math.cos(yaw);
                projectile.m_7678_(x, y, z, projectile.m_146908_(), projectile.m_146909_());
                float velocity = ((Float)entry.getProperty(VELOCITY)).floatValue();
                projectile.m_37251_((Entity)entity, entity.m_146909_(), entity.m_146908_(), 0.0f, velocity, inaccuracy);
                if (((Boolean)entry.getProperty(IGNORE_PLAYER_MOVEMENT)).booleanValue()) {
                    InteractionHand[] vec3 = entity.m_20184_();
                    projectile.m_20256_(projectile.m_20184_().m_82492_(vec3.f_82479_, entity.m_20096_() ? 0.0 : vec3.f_82480_, vec3.f_82481_));
                }
                projectile.m_5602_((Entity)entity);
                for (InteractionHand hand : ((ArmTypeProperty.ArmType)entry.getProperty(SWINGING_ARM)).getHand(entity)) {
                    entity.m_21011_(hand, true);
                }
                if (((Boolean)entry.getProperty(DAMAGE_FROM_PLAYER)).booleanValue() && projectile instanceof CustomProjectile) {
                    CustomProjectile customProjectile = (CustomProjectile)projectile;
                    customProjectile.damage = (float)entity.m_21133_(Attributes.f_22281_);
                }
                return !world.m_8847_((Entity)projectile) ? null : projectile;
            });
        }
    }

    public static float toRadians(Float arg) {
        return (float)((double)arg.floatValue() * (Math.PI / 180));
    }

    public String getDocumentationDescription() {
        return "Allows you to shoot a projectile.";
    }
}

