/*
 * Decompiled with CFR 0.152.
 */
package com.gravestone.gravecore.ability;

import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.threetag.palladium.power.IPowerHolder;
import net.threetag.palladium.power.ability.Ability;
import net.threetag.palladium.power.ability.AbilityInstance;
import net.threetag.palladium.util.icon.ItemIcon;
import net.threetag.palladium.util.property.ArmTypeProperty;
import net.threetag.palladium.util.property.PalladiumProperty;

public class SwingHandsAbility
extends Ability {
    public static final PalladiumProperty<ArmTypeProperty.ArmType> SWINGING_ARM = new ArmTypeProperty("swinging_arm").configurable("Determines which arm(s) should swing");

    public SwingHandsAbility() {
        this.withProperty(ICON, new ItemIcon((ItemLike)Items.f_42469_));
        this.withProperty(SWINGING_ARM, ArmTypeProperty.ArmType.MAIN_ARM);
    }

    public void firstTick(LivingEntity entity, AbilityInstance entry, IPowerHolder holder, boolean enabled) {
        if (enabled) {
            // empty if block
        }
    }

    public void tick(LivingEntity entity, AbilityInstance entry, IPowerHolder holder, boolean enabled) {
        if (enabled) {
            for (InteractionHand hand : ((ArmTypeProperty.ArmType)entry.getProperty(SWINGING_ARM)).getHand(entity)) {
                entity.m_6674_(hand);
            }
        }
    }

    public String getDocumentationDescription() {
        return "makes your hands swing at the enemy.";
    }
}

