/*
 * Decompiled with CFR 0.152.
 */
package com.gravestone.gravecore.forge.abilities;

import com.gravestone.gravecore.forge.compat.lodestone.AuraParticles;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.threetag.palladium.power.IPowerHolder;
import net.threetag.palladium.power.ability.Ability;
import net.threetag.palladium.power.ability.AbilityInstance;
import net.threetag.palladium.util.icon.ItemIcon;
import net.threetag.palladium.util.property.FloatProperty;
import net.threetag.palladium.util.property.IntegerProperty;
import net.threetag.palladium.util.property.PalladiumProperty;
import net.threetag.palladium.util.property.StringProperty;

public class ParticleAuraAbility
extends Ability {
    public static final PalladiumProperty<Integer> COUNT = new IntegerProperty("count").configurable("controls the amount of particles that are summoned");
    public static final PalladiumProperty<String> HEX1 = new StringProperty("start_hex").configurable("controls the main colour of the particle");
    public static final PalladiumProperty<String> HEX2 = new StringProperty("end_hex").configurable("controls what the particle will fade into at the end of its lifetime");
    public static final PalladiumProperty<String> TYPE = new StringProperty("aura_type").configurable("[ aura, wave, column, scream, inner_aura ]. pick the type of particle aura you want.");
    public static final PalladiumProperty<String> PTYPE = new StringProperty("particle_type").configurable("[ smoke, sparkle, wisp, spark, star, twinkle ]. pick particle you want.");
    public static final PalladiumProperty<Float> SIZE = new FloatProperty("particle_size").configurable("controls how large the particles are");
    public static final PalladiumProperty<Float> OPACITY = new FloatProperty("visibility").configurable("controls how visible the particles are");

    public ParticleAuraAbility() {
        this.withProperty(ICON, new ItemIcon((ItemLike)Items.f_151049_));
        this.withProperty(COUNT, 8);
        this.withProperty(HEX1, "#ff17c6");
        this.withProperty(HEX2, "#ff17c6");
        this.withProperty(TYPE, "aura");
        this.withProperty(PTYPE, "smoke");
        this.withProperty(SIZE, Float.valueOf(0.9f));
        this.withProperty(OPACITY, Float.valueOf(0.9f));
    }

    public void tick(LivingEntity entity, AbilityInstance entry, IPowerHolder holder, boolean enabled) {
        if (enabled && entity.m_9236_().m_5776_()) {
            String STARTHEX = ((String)entry.getProperty(HEX1)).toLowerCase();
            String ENDHEX = ((String)entry.getProperty(HEX2)).toLowerCase();
            String type = (String)entry.getProperty(TYPE);
            String ptype = (String)entry.getProperty(PTYPE);
            Integer count = (Integer)entry.getProperty(COUNT);
            Float size = (Float)entry.getProperty(SIZE);
            Float see = Float.valueOf(-((Float)entry.getProperty(OPACITY)).floatValue() + 1.0f);
            if (type.contains("aura")) {
                AuraParticles.spawnAura(entity.m_9236_(), entity.m_20182_(), STARTHEX, ENDHEX, count, ptype, size, see);
            }
            if (type.contains("wave")) {
                AuraParticles.spawnShockwaveRing(entity.m_9236_(), entity.m_20182_(), STARTHEX, ENDHEX, count, ptype, size, see);
            }
            if (type.contains("column")) {
                AuraParticles.spawnColumn(entity.m_9236_(), entity.m_20182_(), STARTHEX, ENDHEX, count, ptype, size, see);
            }
            if (type.contains("scream")) {
                AuraParticles.spawnScreamRing(entity, entity.m_9236_(), entity.m_20182_(), STARTHEX, ENDHEX, count, ptype, size, see);
            }
            if (type.contains("inner_aura")) {
                AuraParticles.spawnInnerStars(entity.m_9236_(), entity.m_20182_(), STARTHEX, ENDHEX, count, ptype, size, see);
            }
        }
    }

    public String getDocumentationDescription() {
        return "summons some fancy new particles via lodestone.";
    }
}

