/*
 * Decompiled with CFR 0.152.
 */
package com.gravestone.gravecore.forge.compat.lodestone;

import com.gravestone.gravecore.util.ColourMagic;
import java.awt.Color;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.registries.RegistryObject;
import team.lodestar.lodestone.registry.common.particle.LodestoneParticleRegistry;
import team.lodestar.lodestone.systems.easing.Easing;
import team.lodestar.lodestone.systems.particle.builder.WorldParticleBuilder;
import team.lodestar.lodestone.systems.particle.data.GenericParticleData;
import team.lodestar.lodestone.systems.particle.data.color.ColorParticleData;
import team.lodestar.lodestone.systems.particle.data.spin.SpinParticleData;

public class AuraParticles {
    public static void spawnAura(Level level, Vec3 pos, String hex_start, String hex_end, Integer count, String particle_type, Float size, Float see) {
        RandomSource random = RandomSource.m_216327_();
        for (int i = 0; i < count; ++i) {
            double angle = random.m_188500_() * Math.PI * 2.0;
            double height = -0.2 + random.m_188500_() * 1.25;
            double maxRadius = 0.225;
            double minRadius = 0.15;
            double radius = maxRadius - (maxRadius - minRadius) * (height + 0.2) / 2.0;
            double x = pos.f_82479_ + Math.cos(angle) * (radius += (random.m_188500_() - (double)see.floatValue()) * 0.1);
            double y = pos.f_82480_ + height;
            double z = pos.f_82481_ + Math.sin(angle) * radius;
            double motionX = -Math.sin(angle) * 0.02 + (random.m_188500_() - 0.5) * 0.01;
            double motionZ = Math.cos(angle) * 0.02 + (random.m_188500_() - 0.5) * 0.01;
            double motionY = 0.03 + random.m_188500_() * 0.04;
            float distanceFraction = (float)((radius - minRadius) / (maxRadius - minRadius));
            float alphaStart = Mth.m_14036_((float)((float)Math.pow(distanceFraction, 3.0)), (float)0.0f, (float)0.2f);
            float alphaEnd = 0.0f;
            if (particle_type.contains("smoke")) {
                AuraParticles.spawnSmokeParticle(level, new Vec3(x, y, z), new Vec3(motionX, motionY, motionZ), alphaStart, alphaEnd, random, hex_start, hex_end, size);
            }
            if (particle_type.contains("sparkle")) {
                AuraParticles.spawnSparkleParticle(level, new Vec3(x, y, z), 0.0, new Vec3(motionX, motionY, motionZ), alphaStart, alphaEnd, random, hex_start, hex_end, size);
            }
            if (particle_type.contains("wisp")) {
                AuraParticles.spawnWispParticle(level, new Vec3(x, y, z), new Vec3(motionX, motionY, motionZ), alphaStart, alphaEnd, random, hex_start, hex_end, size);
            }
            if (particle_type.contains("spark")) {
                AuraParticles.spawnSparkParticle(level, new Vec3(x, y, z), new Vec3(motionX, motionY, motionZ), alphaStart, alphaEnd, random, hex_start, hex_end, size);
            }
            if (particle_type.contains("star")) {
                AuraParticles.spawnStarParticle(level, new Vec3(x, y, z), new Vec3(motionX, motionY, motionZ), alphaStart, alphaEnd, random, hex_start, hex_end, size);
            }
            if (!particle_type.contains("twinkle")) continue;
            AuraParticles.spawnTwinkleParticle(level, new Vec3(x, y, z), new Vec3(motionX, motionY, motionZ), alphaStart, alphaEnd, random, hex_start, hex_end, size);
        }
    }

    public static void spawnShockwaveRing(Level level, Vec3 pos, String hex_start, String hex_end, Integer count, String particle_type, Float size, Float see) {
        RandomSource random = RandomSource.m_216327_();
        double baseSpeed = 0.3;
        for (int i = 0; i < count; ++i) {
            double angle = Math.PI * 2 / (double)count.intValue() * (double)i;
            double motionX = Math.cos(angle) * baseSpeed * (0.8 + random.m_188500_() * 0.4);
            double motionY = 0.02 + random.m_188500_() * 0.02;
            double motionZ = Math.sin(angle) * baseSpeed * (0.8 + random.m_188500_() * 0.4);
            double yOffset = 0.1 + random.m_188500_() * 0.05;
            double x = pos.f_82479_;
            double y = pos.f_82480_;
            double z = pos.f_82481_;
            float alphaStart = see.floatValue();
            float alphaEnd = 0.0f;
            if (particle_type.contains("smoke")) {
                AuraParticles.spawnSmokeParticle(level, new Vec3(x, y, z), new Vec3(motionX, motionY, motionZ), alphaStart, alphaEnd, random, hex_start, hex_end, size);
            }
            if (particle_type.contains("sparkle")) {
                AuraParticles.spawnSparkleParticle(level, new Vec3(x, y, z), yOffset, new Vec3(motionX, motionY, motionZ), alphaStart, alphaEnd, random, hex_start, hex_end, size);
            }
            if (particle_type.contains("wisp")) {
                AuraParticles.spawnWispParticle(level, new Vec3(x, y, z), new Vec3(motionX, motionY, motionZ), alphaStart, alphaEnd, random, hex_start, hex_end, size);
            }
            if (particle_type.contains("spark")) {
                AuraParticles.spawnSparkParticle(level, new Vec3(x, y, z), new Vec3(motionX, motionY, motionZ), alphaStart, alphaEnd, random, hex_start, hex_end, size);
            }
            if (particle_type.contains("star")) {
                AuraParticles.spawnStarParticle(level, new Vec3(x, y, z), new Vec3(motionX, motionY, motionZ), alphaStart, alphaEnd, random, hex_start, hex_end, size);
            }
            if (!particle_type.contains("twinkle")) continue;
            AuraParticles.spawnTwinkleParticle(level, new Vec3(x, y, z), new Vec3(motionX, motionY, motionZ), alphaStart, alphaEnd, random, hex_start, hex_end, size);
        }
    }

    public static void spawnColumn(Level level, Vec3 pos, String hex_start, String hex_end, Integer count, String particle_type, Float size, Float see) {
        RandomSource random = RandomSource.m_216327_();
        for (int i = 0; i < count; ++i) {
            double y = pos.f_82480_ + (double)i * 0.25;
            double flicker = (random.m_188500_() - 0.5) * 0.2;
            double x = pos.f_82479_ + flicker;
            double z = pos.f_82481_ + flicker;
            Vec3 particlePos = new Vec3(x, y, z);
            Vec3 motion = new Vec3(0.0, 0.05 + random.m_188500_() * 0.03, 0.0);
            float alphaStart = see.floatValue();
            float alphaEnd = 0.0f;
            if (particle_type.contains("smoke")) {
                AuraParticles.spawnSmokeParticle(level, particlePos, motion, alphaStart, alphaEnd, random, hex_start, hex_end, size);
            }
            if (particle_type.contains("sparkle")) {
                AuraParticles.spawnSparkleParticle(level, particlePos, 0.0, motion, alphaStart, alphaEnd, random, hex_start, hex_end, size);
            }
            if (particle_type.contains("wisp")) {
                AuraParticles.spawnWispParticle(level, particlePos, motion, alphaStart, alphaEnd, random, hex_start, hex_end, size);
            }
            if (particle_type.contains("spark")) {
                AuraParticles.spawnSparkParticle(level, particlePos, motion, alphaStart, alphaEnd, random, hex_start, hex_end, size);
            }
            if (particle_type.contains("star")) {
                AuraParticles.spawnStarParticle(level, particlePos, motion, alphaStart, alphaEnd, random, hex_start, hex_end, size);
            }
            if (!particle_type.contains("twinkle")) continue;
            AuraParticles.spawnTwinkleParticle(level, new Vec3(x, y, z), motion, alphaStart, alphaEnd, random, hex_start, hex_end, size);
        }
    }

    public static void spawnScreamRing(LivingEntity entity, Level level, Vec3 pos, String hex_start, String hex_end, Integer count, String particle_type, Float size, Float see) {
        RandomSource random = RandomSource.m_216327_();
        double baseSpeed = 0.3;
        for (int i = 0; i < count; ++i) {
            double angle = Math.PI * 2 / (double)count.intValue() * (double)i;
            double motionX = Math.cos(angle) * baseSpeed * (0.8 + random.m_188500_() * 0.4);
            double motionY = 0.02 + random.m_188500_() * 0.02;
            double motionZ = Math.sin(angle) * baseSpeed * (0.8 + random.m_188500_() * 0.4);
            double yOffset = 0.1 + random.m_188500_() * 0.05;
            double x = pos.f_82479_;
            double y = pos.f_82480_ + (double)entity.m_20192_();
            double z = pos.f_82481_;
            float alphaStart = see.floatValue();
            float alphaEnd = 0.0f;
            if (particle_type.contains("smoke")) {
                AuraParticles.spawnSmokeParticle(level, new Vec3(x, y, z), new Vec3(motionX, motionY, motionZ), alphaStart, alphaEnd, random, hex_start, hex_end, size);
            }
            if (particle_type.contains("sparkle")) {
                AuraParticles.spawnSparkleParticle(level, new Vec3(x, y, z), yOffset, new Vec3(motionX, motionY, motionZ), alphaStart, alphaEnd, random, hex_start, hex_end, size);
            }
            if (particle_type.contains("wisp")) {
                AuraParticles.spawnWispParticle(level, new Vec3(x, y, z), new Vec3(motionX, motionY, motionZ), alphaStart, alphaEnd, random, hex_start, hex_end, size);
            }
            if (particle_type.contains("spark")) {
                AuraParticles.spawnSparkParticle(level, new Vec3(x, y, z), new Vec3(motionX, motionY, motionZ), alphaStart, alphaEnd, random, hex_start, hex_end, size);
            }
            if (particle_type.contains("star")) {
                AuraParticles.spawnStarParticle(level, new Vec3(x, y, z), new Vec3(motionX, motionY, motionZ), alphaStart, alphaEnd, random, hex_start, hex_end, size);
            }
            if (!particle_type.contains("twinkle")) continue;
            AuraParticles.spawnTwinkleParticle(level, new Vec3(x, y, z), new Vec3(motionX, motionY, motionZ), alphaStart, alphaEnd, random, hex_start, hex_end, size);
        }
    }

    public static void spawnInnerStars(Level level, Vec3 pos, String hex_start, String hex_end, Integer count, String particle_type, Float size, Float see) {
        RandomSource RANDOM = RandomSource.m_216327_();
        if (RANDOM.m_188501_() > 0.25f) {
            return;
        }
        for (int i = 0; i < count; ++i) {
            double angle = RANDOM.m_188500_() * Math.PI * 2.0;
            double distance = 0.125 + RANDOM.m_188500_() * 0.66;
            double height = -0.1 + RANDOM.m_188500_() * 1.5;
            double x = pos.f_82479_ + Math.cos(angle) * distance;
            double y = pos.f_82480_ + height;
            double z = pos.f_82481_ + Math.sin(angle) * distance;
            Color startColor = new Color(255, 205, 255);
            Color endColor = new Color(200, 100, 255);
            float scaleStart = 0.015f + RANDOM.m_188501_() * (size.floatValue() / 10.0f);
            float scaleEnd = scaleStart + 0.025f + RANDOM.m_188501_() * 0.05f;
            Vec3 motion = Vec3.f_82478_;
            float alphaStart = see.floatValue();
            float alphaEnd = 0.0f;
            if (particle_type.contains("smoke")) {
                AuraParticles.spawnSmokeParticle(level, new Vec3(x, y, z), motion, alphaStart, alphaEnd, RANDOM, hex_start, hex_end, Float.valueOf(scaleEnd));
            }
            if (particle_type.contains("sparkle")) {
                AuraParticles.spawnSparkleParticle(level, new Vec3(x, y, z), 0.0, motion, alphaStart, alphaEnd, RANDOM, hex_start, hex_end, Float.valueOf(scaleEnd));
            }
            if (particle_type.contains("wisp")) {
                AuraParticles.spawnWispParticle(level, new Vec3(x, y, z), motion, alphaStart, alphaEnd, RANDOM, hex_start, hex_end, Float.valueOf(scaleEnd));
            }
            if (particle_type.contains("spark")) {
                AuraParticles.spawnSparkParticle(level, new Vec3(x, y, z), motion, alphaStart, alphaEnd, RANDOM, hex_start, hex_end, Float.valueOf(scaleEnd));
            }
            if (particle_type.contains("star")) {
                AuraParticles.spawnStarParticle(level, new Vec3(x, y, z), motion, alphaStart, alphaEnd, RANDOM, hex_start, hex_end, Float.valueOf(scaleEnd));
            }
            if (!particle_type.contains("twinkle")) continue;
            AuraParticles.spawnTwinkleParticle(level, new Vec3(x, y, z), motion, alphaStart, alphaEnd, RANDOM, hex_start, hex_end, Float.valueOf(scaleEnd));
        }
    }

    private static void spawnSmokeParticle(Level level, Vec3 position, Vec3 motion, float alphaStart, float alphaEnd, RandomSource random, String hex_start, String hex_end, Float size) {
        Color start = ColourMagic.hex2Rgb(hex_start);
        Color end = ColourMagic.hex2Rgb(hex_end);
        WorldParticleBuilder.create((RegistryObject)LodestoneParticleRegistry.SMOKE_PARTICLE).setColorData(ColorParticleData.create((Color)start, (Color)end).setEasing(Easing.CUBIC_IN_OUT).build()).setTransparencyData(GenericParticleData.create((float)alphaStart, (float)alphaEnd).setEasing(Easing.QUAD_OUT).build()).setScaleData(GenericParticleData.create((float)0.3f, (float)size.floatValue(), (float)0.0f).setEasing(Easing.QUAD_IN_OUT).build()).setSpinData(SpinParticleData.createRandomDirection((RandomSource)random, (float)0.03f, (float)0.25f).setEasing(Easing.EXPO_IN_OUT).build()).setLifetime(35 + random.m_188503_(15)).addMotion(motion.f_82479_, motion.f_82480_, motion.f_82481_).spawn(level, position.f_82479_, position.f_82480_, position.f_82481_);
    }

    private static void spawnSparkleParticle(Level level, Vec3 position, Double yOffset, Vec3 motion, float alphaStart, float alphaEnd, RandomSource random, String hex_start, String hex_end, Float size) {
        Color start = ColourMagic.hex2Rgb(hex_start);
        Color end = ColourMagic.hex2Rgb(hex_end);
        WorldParticleBuilder.create((RegistryObject)LodestoneParticleRegistry.SPARKLE_PARTICLE).setColorData(ColorParticleData.create((Color)start, (Color)end).setEasing(Easing.CUBIC_OUT).build()).setTransparencyData(GenericParticleData.create((float)0.5f, (float)0.0f).setEasing(Easing.SINE_IN_OUT).build()).setScaleData(GenericParticleData.create((float)size.floatValue(), (float)0.0f).setEasing(Easing.EXPO_OUT).build()).setSpinData(SpinParticleData.createRandomDirection((RandomSource)random, (float)0.03f, (float)0.25f).setEasing(Easing.EXPO_IN_OUT).build()).setLifetime(20 + random.m_188503_(10)).addMotion(motion.f_82479_, motion.f_82480_, motion.f_82481_).spawn(level, position.f_82479_, position.f_82480_ + yOffset, position.f_82481_);
    }

    private static void spawnWispParticle(Level level, Vec3 position, Vec3 motion, float alphaStart, float alphaEnd, RandomSource random, String hex_start, String hex_end, Float size) {
        Color start = ColourMagic.hex2Rgb(hex_start);
        Color end = ColourMagic.hex2Rgb(hex_end);
        WorldParticleBuilder.create((RegistryObject)LodestoneParticleRegistry.WISP_PARTICLE).setColorData(ColorParticleData.create((Color)start, (Color)end).setEasing(Easing.CUBIC_IN_OUT).build()).setTransparencyData(GenericParticleData.create((float)alphaStart, (float)alphaEnd).setEasing(Easing.QUAD_OUT).build()).setScaleData(GenericParticleData.create((float)0.3f, (float)size.floatValue(), (float)0.0f).setEasing(Easing.QUAD_IN_OUT).build()).setSpinData(SpinParticleData.createRandomDirection((RandomSource)random, (float)0.03f, (float)0.25f).setEasing(Easing.EXPO_IN_OUT).build()).setLifetime(35 + random.m_188503_(15)).addMotion(motion.f_82479_, motion.f_82480_, motion.f_82481_).spawn(level, position.f_82479_, position.f_82480_, position.f_82481_);
    }

    private static void spawnSparkParticle(Level level, Vec3 position, Vec3 motion, float alphaStart, float alphaEnd, RandomSource random, String hex_start, String hex_end, Float size) {
        Color start = ColourMagic.hex2Rgb(hex_start);
        Color end = ColourMagic.hex2Rgb(hex_end);
        WorldParticleBuilder.create((RegistryObject)LodestoneParticleRegistry.SPARK_PARTICLE).setColorData(ColorParticleData.create((Color)start, (Color)end).setEasing(Easing.CUBIC_IN_OUT).build()).setTransparencyData(GenericParticleData.create((float)alphaStart, (float)alphaEnd).setEasing(Easing.QUAD_OUT).build()).setScaleData(GenericParticleData.create((float)0.3f, (float)size.floatValue(), (float)0.0f).setEasing(Easing.QUAD_IN_OUT).build()).setSpinData(SpinParticleData.createRandomDirection((RandomSource)random, (float)0.03f, (float)0.25f).setEasing(Easing.EXPO_IN_OUT).build()).setLifetime(35 + random.m_188503_(15)).addMotion(motion.f_82479_, motion.f_82480_, motion.f_82481_).spawn(level, position.f_82479_, position.f_82480_, position.f_82481_);
    }

    private static void spawnStarParticle(Level level, Vec3 position, Vec3 motion, float alphaStart, float alphaEnd, RandomSource random, String hex_start, String hex_end, Float size) {
        Color start = ColourMagic.hex2Rgb(hex_start);
        Color end = ColourMagic.hex2Rgb(hex_end);
        WorldParticleBuilder.create((RegistryObject)LodestoneParticleRegistry.STAR_PARTICLE).setColorData(ColorParticleData.create((Color)start, (Color)end).setEasing(Easing.CUBIC_IN_OUT).build()).setTransparencyData(GenericParticleData.create((float)alphaStart, (float)alphaEnd).setEasing(Easing.QUAD_OUT).build()).setScaleData(GenericParticleData.create((float)0.3f, (float)size.floatValue(), (float)0.0f).setEasing(Easing.QUAD_IN_OUT).build()).setSpinData(SpinParticleData.createRandomDirection((RandomSource)random, (float)0.03f, (float)0.25f).setEasing(Easing.EXPO_IN_OUT).build()).setLifetime(35 + random.m_188503_(15)).addMotion(motion.f_82479_, motion.f_82480_, motion.f_82481_).spawn(level, position.f_82479_, position.f_82480_, position.f_82481_);
    }

    private static void spawnTwinkleParticle(Level level, Vec3 position, Vec3 motion, float alphaStart, float alphaEnd, RandomSource random, String hex_start, String hex_end, Float size) {
        Color start = ColourMagic.hex2Rgb(hex_start);
        Color end = ColourMagic.hex2Rgb(hex_end);
        WorldParticleBuilder.create((RegistryObject)LodestoneParticleRegistry.TWINKLE_PARTICLE).setColorData(ColorParticleData.create((Color)start, (Color)end).setEasing(Easing.SINE_IN_OUT).build()).setTransparencyData(GenericParticleData.create((float)1.0f, (float)0.0f).setEasing(Easing.SINE_IN_OUT).build()).setScaleData(GenericParticleData.create((float)0.1f, (float)size.floatValue(), (float)0.0f).setEasing(Easing.EXPO_OUT).build()).setSpinData(SpinParticleData.createRandomDirection((RandomSource)random, (float)0.01f, (float)0.05f).setEasing(Easing.LINEAR).build()).setLifetime(40 + random.m_188503_(30)).enableNoClip().addMotion(motion.f_82479_, motion.f_82480_, motion.f_82481_).spawn(level, position.f_82479_, position.f_82480_, position.f_82481_);
    }
}

