/*
 * Decompiled with CFR 0.152.
 */
package com.gravestone.gravecore.world;

import com.google.common.base.Suppliers;
import com.gravestone.gravecore.GraveCore;
import com.gravestone.gravecore.block.CoreBlocks;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.OreConfiguration;
import net.minecraft.world.level.levelgen.structure.templatesystem.RuleTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.TagMatchTest;

public class CoreConfiguredFeatures {
    public static final Supplier<List<OreConfiguration.TargetBlockState>> PALLADIUM_ORE_REPLACEMENT = Suppliers.memoize(() -> List.of(OreConfiguration.m_161021_((RuleTest)new TagMatchTest(BlockTags.f_13062_), (BlockState)((Block)CoreBlocks.PALLADIUM_ORE.get()).m_49966_())));
    public static final Supplier<List<OreConfiguration.TargetBlockState>> DEEPSLATE_TITANIUM_ORE_REPLACEMENT = Suppliers.memoize(() -> List.of(OreConfiguration.m_161021_((RuleTest)new TagMatchTest(BlockTags.f_144267_), (BlockState)((Block)CoreBlocks.DEEPSLATE_TITANIUM_ORE.get()).m_49966_())));
    public static final ResourceKey<ConfiguredFeature<?, ?>> PALLADIUM_ORE_KEY = CoreConfiguredFeatures.registerKey("nether_palladium_ore");
    public static final ResourceKey<ConfiguredFeature<?, ?>> DEEPSLATE_TITANIUM_ORE_KEY = CoreConfiguredFeatures.registerKey("deepslate_titanium_ore");

    public static void bootstrap(BootstapContext<ConfiguredFeature<?, ?>> context) {
        CoreConfiguredFeatures.register(context, PALLADIUM_ORE_KEY, Feature.f_65731_, new OreConfiguration(PALLADIUM_ORE_REPLACEMENT.get(), 7));
        CoreConfiguredFeatures.register(context, DEEPSLATE_TITANIUM_ORE_KEY, Feature.f_65731_, new OreConfiguration(DEEPSLATE_TITANIUM_ORE_REPLACEMENT.get(), 4));
    }

    public static ResourceKey<ConfiguredFeature<?, ?>> registerKey(String name) {
        return ResourceKey.m_135785_((ResourceKey)Registries.f_256911_, (ResourceLocation)GraveCore.id(name));
    }

    private static <FC extends FeatureConfiguration, F extends Feature<FC>> void register(BootstapContext<ConfiguredFeature<?, ?>> context, ResourceKey<ConfiguredFeature<?, ?>> key, F feature, FC configuration) {
        context.m_255272_(key, (Object)new ConfiguredFeature(feature, configuration));
    }
}

