/*
 * Decompiled with CFR 0.152.
 */
package com.gravestone.gravecore.world;

import com.gravestone.gravecore.GraveCore;
import com.gravestone.gravecore.world.CoreConfiguredFeatures;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.levelgen.VerticalAnchor;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.placement.BiomeFilter;
import net.minecraft.world.level.levelgen.placement.HeightRangePlacement;
import net.minecraft.world.level.levelgen.placement.InSquarePlacement;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import net.minecraft.world.level.levelgen.placement.RarityFilter;

public class CorePlacedFeatures {
    public static final ResourceKey<PlacedFeature> PALLADIUM_ORE_VEIN = CorePlacedFeatures.createKey("nether_palladium_ore_placed");
    public static final ResourceKey<PlacedFeature> DEEPSLATE_TITANIUM_ORE_VEIN = CorePlacedFeatures.createKey("deepslate_titanium_ore_placed");

    public static void bootstrap(BootstapContext<PlacedFeature> context) {
        HolderGetter configuredFeatures = context.m_255420_(Registries.f_256911_);
        CorePlacedFeatures.register(context, PALLADIUM_ORE_VEIN, configuredFeatures.m_255043_(CoreConfiguredFeatures.PALLADIUM_ORE_KEY), CorePlacedFeatures.rareOrePlacement(8, (PlacementModifier)HeightRangePlacement.m_191680_((VerticalAnchor)VerticalAnchor.m_158921_(), (VerticalAnchor)VerticalAnchor.m_158922_((int)40))));
        CorePlacedFeatures.register(context, DEEPSLATE_TITANIUM_ORE_VEIN, configuredFeatures.m_255043_(CoreConfiguredFeatures.DEEPSLATE_TITANIUM_ORE_KEY), CorePlacedFeatures.rareOrePlacement(3, (PlacementModifier)HeightRangePlacement.m_191680_((VerticalAnchor)VerticalAnchor.m_158921_(), (VerticalAnchor)VerticalAnchor.m_158922_((int)40))));
    }

    private static List<PlacementModifier> orePlacement(PlacementModifier placementModifier, PlacementModifier placementModifier2) {
        return List.of(placementModifier, InSquarePlacement.m_191715_(), placementModifier2, BiomeFilter.m_191561_());
    }

    private static List<PlacementModifier> rareOrePlacement(int chance, PlacementModifier heightRange) {
        return CorePlacedFeatures.orePlacement((PlacementModifier)RarityFilter.m_191900_((int)chance), heightRange);
    }

    private static ResourceKey<PlacedFeature> createKey(String name) {
        return ResourceKey.m_135785_((ResourceKey)Registries.f_256988_, (ResourceLocation)GraveCore.id(name));
    }

    private static void register(BootstapContext<PlacedFeature> context, ResourceKey<PlacedFeature> key, Holder<ConfiguredFeature<?, ?>> configuration, List<PlacementModifier> modifiers) {
        context.m_255272_(key, (Object)new PlacedFeature(configuration, List.copyOf(modifiers)));
    }

    private static void register(BootstapContext<PlacedFeature> context, ResourceKey<PlacedFeature> key, Holder<ConfiguredFeature<?, ?>> configuration, PlacementModifier ... modifiers) {
        CorePlacedFeatures.register(context, key, configuration, List.of(modifiers));
    }
}

