let SizeUtil = Java.loadClass('net.threetag.palladium.util.SizeUtil');

StartupEvents.registry('palladium:abilities', (event) => {
  event.create('gravestone:dynamic_pehkui')
    .icon(palladium.createItemIcon('minecraft:blaze_rod'))
    .documentationDescription('lets the player tie a scoreboard to any scale type or just set any scale type normally.')

    .addProperty("scale_type", "string", "palladium:ability", "from the list of pehkui scales in game")
    .addProperty("scale_number", "float", 1.1, "what you set the scale to if not by scoreboard")
    .addProperty("scoreboard", "string", "grave.scale.test", "Motion Scale")
    .addProperty("scoreboard_divider", "float", 0, "what you divide the score by")
    .addProperty("delay", "integer", 0, "what you divide the score by")
    .addProperty("is_score", "string", "true", "True or False")
	
	
    .tick((entity, entry, holder, enabled) => {
      if (enabled) {
        let scale_type = entry.getPropertyByName("scale_type")
        let scale_number = entry.getPropertyByName("scale_number")
        let divider = entry.getPropertyByName("scoreboard_divider")
        let is_score = entry.getPropertyByName("is_score")
        let delay = entry.getPropertyByName("delay")
        let username = entity.getGameProfile().getName();
        let username_true = username.toLowerCase();
        let scoreboard = Utils.server.scoreboard;
        let scoreboard_obj = scoreboard.getObjective(entry.getPropertyByName("scoreboard"));
        let score = scoreboard.getOrCreatePlayerScore(username, scoreboard_obj);
        let value = score.getScore();

        if (is_score == 'False') {
          SizeUtil.getInstance().startScaleChange(entity, scale_type, scale_number, delay);
        }
        if (is_score == 'True') {
          SizeUtil.getInstance().startScaleChange(entity, scale_type, (value/divider), delay);
        }

      }
    })

    .lastTick((entity, entry, holder, enabled) => {
      if (enabled) {
        let scale_type = entry.getPropertyByName("scale_type")
        let delay = entry.getPropertyByName("delay")

        SizeUtil.getInstance().startScaleChange(entity, scale_type, 1, delay);

      }
    });

});