const keyCodeToName = {
    32: "SPACE",
    39: "APOSTROPHE",
    44: "COMMA",
    45: "MINUS",
    46: "PERIOD",
    47: "SLASH",
    48: "0",
    49: "1",
    50: "2",
    51: "3",
    52: "4",
    53: "5",
    54: "6",
    55: "7",
    56: "8",
    57: "9",
    59: "SEMICOLON",
    61: "EQUAL",
    65: "A",
    66: "B",
    67: "C",
    68: "D",
    69: "E",
    70: "F",
    71: "G",
    72: "H",
    73: "I",
    74: "J",
    75: "K",
    76: "L",
    77: "M",
    78: "N",
    79: "O",
    80: "P",
    81: "Q",
    82: "R",
    83: "S",
    84: "T",
    85: "U",
    86: "V",
    87: "W",
    88: "X",
    89: "Y",
    90: "Z",
    91: "LEFT_SUPER",
    92: "RIGHT_SUPER",
    93: "MENU",
    96: "KP_0",
    97: "KP_1",
    98: "KP_2",
    99: "KP_3",
    100: "KP_4",
    101: "KP_5",
    102: "KP_6",
    103: "KP_7",
    104: "KP_8",
    105: "KP_9",
    106: "KP_DECIMAL",
    107: "KP_DIVIDE",
    108: "KP_MULTIPLY",
    109: "KP_SUBTRACT",
    110: "KP_ADD",
    111: "KP_ENTER",
    112: "KP_EQUAL",
    256: "ESCAPE",
    257: "ENTER",
    258: "TAB",
    259: "BACKSPACE",
    260: "INSERT",
    261: "DELETE",
    262: "RIGHT",
    263: "LEFT",
    264: "DOWN",
    265: "UP",
    266: "PAGE_UP",
    267: "PAGE_DOWN",
    268: "HOME",
    269: "END",
    280: "CAPS_LOCK",
    281: "SCROLL_LOCK",
    282: "NUM_LOCK",
    283: "PRINT_SCREEN",
    284: "PAUSE",
    290: "F1",
    291: "F2",
    292: "F3",
    293: "F4",
    294: "F5",
    295: "F6",
    296: "F7",
    297: "F8",
    298: "F9",
    299: "F10",
    300: "F11",
    301: "F12",
    340: "LEFT_SHIFT",
    341: "LEFT_CONTROL",
    342: "LEFT_ALT",
    343: "LEFT_SUPER",
    344: "RIGHT_SHIFT",
    345: "RIGHT_CONTROL",
    346: "RIGHT_ALT",
    347: "RIGHT_SUPER",
    348: "MENU"
};

StartupEvents.registry('palladium:condition_serializer', (event) => {
    event.create('gravestone:key_condition')
        .addProperty("key", "string", "SPACE", 'Key press to activate condition, ex. "RIGHT_ALT"')
        .test((entity, props) => {
            let graveKey = entity.persistentData.graveKey;
            let key = props.get("key").toUpperCase();
            if (graveKey === null || graveKey === undefined) {
                return false;
            }
            let keyName = keyCodeToName[parseInt(graveKey)];
            let result = keyName === key;
            if (result) {
                entity.persistentData.graveKey = null;
            }
            return result;
        })
});