StartupEvents.registry('palladium:condition_serializer', (event) => {
    event.create('gravestone:persistent_data_condition')
      .addProperty("persistent_data", "string", "gravecamera", "Persistent data to search through")
      .addProperty("value", "string", "FIRST_PERSON", "value to compare against")
      .addProperty("sign", "string", "==", "==, !=, <=, >=, >, <")
      .test((entity, props) => {
        let data = props.get("persistent_data");
        let value = props.get("value");
        let sign = props.get("sign");
        switch (sign) {
          case "==":
            return entity.persistentData[data] == value;
          case "!=":
            return entity.persistentData[data] != value;
          case "<":
            return entity.persistentData[data] < value;
          case "<=":
            return entity.persistentData[data] <= value;
          case ">":
            return entity.persistentData[data] > value;
          case ">=":
            return entity.persistentData[data] >= value;
          default:
            return false
        }
    })
});