StartupEvents.registry('palladium:abilities', (event) => {

    event.create('gravestone:stone_index_detection')

        .icon(palladium.createItemIcon('palladium:vibranium_circuit'))
        .documentationDescription('detects the most common block from the stone index in a BLANK radius')

		.addProperty('score', 'string', 'cm.ninjago.earth.index', 'the scoreboard that the type is put in')
        .addProperty('needs', 'integer', 6, 'the required amount of any 1 block')

        .tick((entity, entry, holder, enabled) => {
            if (enabled) {
				const score = entry.getPropertyByName('score');
				const needs = entry.getPropertyByName('needs');
                let username = entity.getGameProfile().getName();
                let username_true = username.toLowerCase();

                let max_type = global.material_types;

                for (let types = 0; types <= max_type; types++) {
                    entity.persistentData['material_type_' + types] = 0
                }
					
                for (let pos of BlockPos.betweenClosed(new BlockPos(entity.x + 5, entity.y + 5, entity.z + 5), [entity.x - 5, entity.y - 5, entity.z - 5])) {
                    
                for (let types = 0; types <= max_type; types++) {
                    let material_type = global['material_type_' + types].toString();
                    if(entity.getLevel().getBlock(pos).id === material_type) {
                        entity.persistentData['material_type_' + types] = entity.persistentData['material_type_' + types] + 1
                        }
                    }
                }
                // select rock type
                let check_type = -1	
                for (let types = 0; types <= max_type; types++) {
                    let total = entity.persistentData['material_type_' + types]
                         if (total >= needs) {
                            if (types > check_type) {
                                check_type = types
                        }
                    }
                }
                entity.server.runCommandSilent("scoreboard players set " + username + " " + score + " " + check_type + "");

            }
        })
});
