/*
 * Decompiled with CFR 0.152.
 */
package com.gravestone.gravecore.condition;

import com.google.gson.JsonObject;
import com.gravestone.gravecore.condition.CoreConditions;
import java.util.UUID;
import net.minecraft.class_1309;
import net.threetag.palladium.condition.Condition;
import net.threetag.palladium.condition.ConditionSerializer;
import net.threetag.palladium.util.context.DataContext;
import net.threetag.palladium.util.property.PalladiumProperty;
import net.threetag.palladium.util.property.UUIDProperty;

public class UUIDCondition
extends Condition {
    private final UUID uuid;

    public UUIDCondition(UUID uuid) {
        this.uuid = uuid;
    }

    public boolean active(DataContext context) {
        class_1309 entity = context.getLivingEntity();
        if (entity == null) {
            return false;
        }
        UUID check_id = entity.method_5667();
        return check_id.equals(this.uuid);
    }

    public ConditionSerializer getSerializer() {
        return (ConditionSerializer)CoreConditions.UUID.get();
    }

    public static class Serializer
    extends ConditionSerializer {
        public static final PalladiumProperty<UUID> UUID = new UUIDProperty("uuid").configurable("the uuid of a player.");

        public Serializer() {
            this.withProperty(UUID, java.util.UUID.fromString("b7ce1b6e-0e7c-41a6-b3cb-e847a381debf"));
        }

        public Condition make(JsonObject json) {
            return new UUIDCondition((UUID)this.getProperty(json, UUID));
        }

        public String getDocumentationDescription() {
            return "checks if the current entity is a player";
        }
    }
}

