/*
 * Decompiled with CFR 0.152.
 */
package com.gravestone.gravecore.fabric.compat.lodestone;

import com.gravestone.gravecore.util.ColourMagic;
import io.github.fabricators_of_create.porting_lib.util.RegistryObject;
import java.awt.Color;
import net.minecraft.class_1309;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_3532;
import net.minecraft.class_5819;
import team.lodestar.lodestone.registry.common.particle.LodestoneParticleRegistry;
import team.lodestar.lodestone.systems.easing.Easing;
import team.lodestar.lodestone.systems.particle.builder.WorldParticleBuilder;
import team.lodestar.lodestone.systems.particle.data.GenericParticleData;
import team.lodestar.lodestone.systems.particle.data.color.ColorParticleData;
import team.lodestar.lodestone.systems.particle.data.spin.SpinParticleData;

public class AuraParticles {
    public static void spawnAura(class_1937 level, class_243 pos, String hex_start, String hex_end, Integer count, String particle_type, Float size, Float see) {
        class_5819 random = class_5819.method_43047();
        for (int i = 0; i < count; ++i) {
            double angle = random.method_43058() * Math.PI * 2.0;
            double height = -0.2 + random.method_43058() * 1.25;
            double maxRadius = 0.225;
            double minRadius = 0.15;
            double radius = maxRadius - (maxRadius - minRadius) * (height + 0.2) / 2.0;
            double x = pos.field_1352 + Math.cos(angle) * (radius += (random.method_43058() - (double)see.floatValue()) * 0.1);
            double y = pos.field_1351 + height;
            double z = pos.field_1350 + Math.sin(angle) * radius;
            double motionX = -Math.sin(angle) * 0.02 + (random.method_43058() - 0.5) * 0.01;
            double motionZ = Math.cos(angle) * 0.02 + (random.method_43058() - 0.5) * 0.01;
            double motionY = 0.03 + random.method_43058() * 0.04;
            float distanceFraction = (float)((radius - minRadius) / (maxRadius - minRadius));
            float alphaStart = class_3532.method_15363((float)((float)Math.pow(distanceFraction, 3.0)), (float)0.0f, (float)0.2f);
            float alphaEnd = 0.0f;
            if (particle_type.contains("smoke")) {
                AuraParticles.spawnSmokeParticle(level, new class_243(x, y, z), new class_243(motionX, motionY, motionZ), alphaStart, alphaEnd, random, hex_start, hex_end, size);
            }
            if (particle_type.contains("sparkle")) {
                AuraParticles.spawnSparkleParticle(level, new class_243(x, y, z), 0.0, new class_243(motionX, motionY, motionZ), alphaStart, alphaEnd, random, hex_start, hex_end, size);
            }
            if (particle_type.contains("wisp")) {
                AuraParticles.spawnWispParticle(level, new class_243(x, y, z), new class_243(motionX, motionY, motionZ), alphaStart, alphaEnd, random, hex_start, hex_end, size);
            }
            if (particle_type.contains("spark")) {
                AuraParticles.spawnSparkParticle(level, new class_243(x, y, z), new class_243(motionX, motionY, motionZ), alphaStart, alphaEnd, random, hex_start, hex_end, size);
            }
            if (particle_type.contains("star")) {
                AuraParticles.spawnStarParticle(level, new class_243(x, y, z), new class_243(motionX, motionY, motionZ), alphaStart, alphaEnd, random, hex_start, hex_end, size);
            }
            if (!particle_type.contains("twinkle")) continue;
            AuraParticles.spawnTwinkleParticle(level, new class_243(x, y, z), new class_243(motionX, motionY, motionZ), alphaStart, alphaEnd, random, hex_start, hex_end, size);
        }
    }

    public static void spawnShockwaveRing(class_1937 level, class_243 pos, String hex_start, String hex_end, Integer count, String particle_type, Float size, Float see) {
        class_5819 random = class_5819.method_43047();
        double baseSpeed = 0.3;
        for (int i = 0; i < count; ++i) {
            double angle = Math.PI * 2 / (double)count.intValue() * (double)i;
            double motionX = Math.cos(angle) * baseSpeed * (0.8 + random.method_43058() * 0.4);
            double motionY = 0.02 + random.method_43058() * 0.02;
            double motionZ = Math.sin(angle) * baseSpeed * (0.8 + random.method_43058() * 0.4);
            double yOffset = 0.1 + random.method_43058() * 0.05;
            double x = pos.field_1352;
            double y = pos.field_1351;
            double z = pos.field_1350;
            float alphaStart = see.floatValue();
            float alphaEnd = 0.0f;
            if (particle_type.contains("smoke")) {
                AuraParticles.spawnSmokeParticle(level, new class_243(x, y, z), new class_243(motionX, motionY, motionZ), alphaStart, alphaEnd, random, hex_start, hex_end, size);
            }
            if (particle_type.contains("sparkle")) {
                AuraParticles.spawnSparkleParticle(level, new class_243(x, y, z), yOffset, new class_243(motionX, motionY, motionZ), alphaStart, alphaEnd, random, hex_start, hex_end, size);
            }
            if (particle_type.contains("wisp")) {
                AuraParticles.spawnWispParticle(level, new class_243(x, y, z), new class_243(motionX, motionY, motionZ), alphaStart, alphaEnd, random, hex_start, hex_end, size);
            }
            if (particle_type.contains("spark")) {
                AuraParticles.spawnSparkParticle(level, new class_243(x, y, z), new class_243(motionX, motionY, motionZ), alphaStart, alphaEnd, random, hex_start, hex_end, size);
            }
            if (particle_type.contains("star")) {
                AuraParticles.spawnStarParticle(level, new class_243(x, y, z), new class_243(motionX, motionY, motionZ), alphaStart, alphaEnd, random, hex_start, hex_end, size);
            }
            if (!particle_type.contains("twinkle")) continue;
            AuraParticles.spawnTwinkleParticle(level, new class_243(x, y, z), new class_243(motionX, motionY, motionZ), alphaStart, alphaEnd, random, hex_start, hex_end, size);
        }
    }

    public static void spawnColumn(class_1937 level, class_243 pos, String hex_start, String hex_end, Integer count, String particle_type, Float size, Float see) {
        class_5819 random = class_5819.method_43047();
        for (int i = 0; i < count; ++i) {
            double y = pos.field_1351 + (double)i * 0.25;
            double flicker = (random.method_43058() - 0.5) * 0.2;
            double x = pos.field_1352 + flicker;
            double z = pos.field_1350 + flicker;
            class_243 particlePos = new class_243(x, y, z);
            class_243 motion = new class_243(0.0, 0.05 + random.method_43058() * 0.03, 0.0);
            float alphaStart = see.floatValue();
            float alphaEnd = 0.0f;
            if (particle_type.contains("smoke")) {
                AuraParticles.spawnSmokeParticle(level, particlePos, motion, alphaStart, alphaEnd, random, hex_start, hex_end, size);
            }
            if (particle_type.contains("sparkle")) {
                AuraParticles.spawnSparkleParticle(level, particlePos, 0.0, motion, alphaStart, alphaEnd, random, hex_start, hex_end, size);
            }
            if (particle_type.contains("wisp")) {
                AuraParticles.spawnWispParticle(level, particlePos, motion, alphaStart, alphaEnd, random, hex_start, hex_end, size);
            }
            if (particle_type.contains("spark")) {
                AuraParticles.spawnSparkParticle(level, particlePos, motion, alphaStart, alphaEnd, random, hex_start, hex_end, size);
            }
            if (particle_type.contains("star")) {
                AuraParticles.spawnStarParticle(level, particlePos, motion, alphaStart, alphaEnd, random, hex_start, hex_end, size);
            }
            if (!particle_type.contains("twinkle")) continue;
            AuraParticles.spawnTwinkleParticle(level, new class_243(x, y, z), motion, alphaStart, alphaEnd, random, hex_start, hex_end, size);
        }
    }

    public static void spawnScreamRing(class_1309 entity, class_1937 level, class_243 pos, String hex_start, String hex_end, Integer count, String particle_type, Float size, Float see) {
        class_5819 random = class_5819.method_43047();
        double baseSpeed = 0.3;
        for (int i = 0; i < count; ++i) {
            double angle = Math.PI * 2 / (double)count.intValue() * (double)i;
            double motionX = Math.cos(angle) * baseSpeed * (0.8 + random.method_43058() * 0.4);
            double motionY = 0.02 + random.method_43058() * 0.02;
            double motionZ = Math.sin(angle) * baseSpeed * (0.8 + random.method_43058() * 0.4);
            double yOffset = 0.1 + random.method_43058() * 0.05;
            double x = pos.field_1352;
            double y = pos.field_1351 + (double)entity.method_5751();
            double z = pos.field_1350;
            float alphaStart = see.floatValue();
            float alphaEnd = 0.0f;
            if (particle_type.contains("smoke")) {
                AuraParticles.spawnSmokeParticle(level, new class_243(x, y, z), new class_243(motionX, motionY, motionZ), alphaStart, alphaEnd, random, hex_start, hex_end, size);
            }
            if (particle_type.contains("sparkle")) {
                AuraParticles.spawnSparkleParticle(level, new class_243(x, y, z), yOffset, new class_243(motionX, motionY, motionZ), alphaStart, alphaEnd, random, hex_start, hex_end, size);
            }
            if (particle_type.contains("wisp")) {
                AuraParticles.spawnWispParticle(level, new class_243(x, y, z), new class_243(motionX, motionY, motionZ), alphaStart, alphaEnd, random, hex_start, hex_end, size);
            }
            if (particle_type.contains("spark")) {
                AuraParticles.spawnSparkParticle(level, new class_243(x, y, z), new class_243(motionX, motionY, motionZ), alphaStart, alphaEnd, random, hex_start, hex_end, size);
            }
            if (particle_type.contains("star")) {
                AuraParticles.spawnStarParticle(level, new class_243(x, y, z), new class_243(motionX, motionY, motionZ), alphaStart, alphaEnd, random, hex_start, hex_end, size);
            }
            if (!particle_type.contains("twinkle")) continue;
            AuraParticles.spawnTwinkleParticle(level, new class_243(x, y, z), new class_243(motionX, motionY, motionZ), alphaStart, alphaEnd, random, hex_start, hex_end, size);
        }
    }

    public static void spawnInnerStars(class_1937 level, class_243 pos, String hex_start, String hex_end, Integer count, String particle_type, Float size, Float see) {
        class_5819 RANDOM = class_5819.method_43047();
        if (RANDOM.method_43057() > 0.25f) {
            return;
        }
        for (int i = 0; i < count; ++i) {
            double angle = RANDOM.method_43058() * Math.PI * 2.0;
            double distance = 0.125 + RANDOM.method_43058() * 0.66;
            double height = -0.1 + RANDOM.method_43058() * 1.5;
            double x = pos.field_1352 + Math.cos(angle) * distance;
            double y = pos.field_1351 + height;
            double z = pos.field_1350 + Math.sin(angle) * distance;
            Color startColor = new Color(255, 205, 255);
            Color endColor = new Color(200, 100, 255);
            float scaleStart = 0.015f + RANDOM.method_43057() * (size.floatValue() / 10.0f);
            float scaleEnd = scaleStart + 0.025f + RANDOM.method_43057() * 0.05f;
            class_243 motion = class_243.field_1353;
            float alphaStart = see.floatValue();
            float alphaEnd = 0.0f;
            if (particle_type.contains("smoke")) {
                AuraParticles.spawnSmokeParticle(level, new class_243(x, y, z), motion, alphaStart, alphaEnd, RANDOM, hex_start, hex_end, Float.valueOf(scaleEnd));
            }
            if (particle_type.contains("sparkle")) {
                AuraParticles.spawnSparkleParticle(level, new class_243(x, y, z), 0.0, motion, alphaStart, alphaEnd, RANDOM, hex_start, hex_end, Float.valueOf(scaleEnd));
            }
            if (particle_type.contains("wisp")) {
                AuraParticles.spawnWispParticle(level, new class_243(x, y, z), motion, alphaStart, alphaEnd, RANDOM, hex_start, hex_end, Float.valueOf(scaleEnd));
            }
            if (particle_type.contains("spark")) {
                AuraParticles.spawnSparkParticle(level, new class_243(x, y, z), motion, alphaStart, alphaEnd, RANDOM, hex_start, hex_end, Float.valueOf(scaleEnd));
            }
            if (particle_type.contains("star")) {
                AuraParticles.spawnStarParticle(level, new class_243(x, y, z), motion, alphaStart, alphaEnd, RANDOM, hex_start, hex_end, Float.valueOf(scaleEnd));
            }
            if (!particle_type.contains("twinkle")) continue;
            AuraParticles.spawnTwinkleParticle(level, new class_243(x, y, z), motion, alphaStart, alphaEnd, RANDOM, hex_start, hex_end, Float.valueOf(scaleEnd));
        }
    }

    private static void spawnSmokeParticle(class_1937 level, class_243 position, class_243 motion, float alphaStart, float alphaEnd, class_5819 random, String hex_start, String hex_end, Float size) {
        Color start = ColourMagic.hex2Rgb(hex_start);
        Color end = ColourMagic.hex2Rgb(hex_end);
        WorldParticleBuilder.create((RegistryObject)LodestoneParticleRegistry.SMOKE_PARTICLE).setColorData(ColorParticleData.create((Color)start, (Color)end).setEasing(Easing.CUBIC_IN_OUT).build()).setTransparencyData(GenericParticleData.create((float)alphaStart, (float)alphaEnd).setEasing(Easing.QUAD_OUT).build()).setScaleData(GenericParticleData.create((float)0.3f, (float)size.floatValue(), (float)0.0f).setEasing(Easing.QUAD_IN_OUT).build()).setSpinData(SpinParticleData.createRandomDirection((class_5819)random, (float)0.03f, (float)0.25f).setEasing(Easing.EXPO_IN_OUT).build()).setLifetime(35 + random.method_43048(15)).addMotion(motion.field_1352, motion.field_1351, motion.field_1350).spawn(level, position.field_1352, position.field_1351, position.field_1350);
    }

    private static void spawnSparkleParticle(class_1937 level, class_243 position, Double yOffset, class_243 motion, float alphaStart, float alphaEnd, class_5819 random, String hex_start, String hex_end, Float size) {
        Color start = ColourMagic.hex2Rgb(hex_start);
        Color end = ColourMagic.hex2Rgb(hex_end);
        WorldParticleBuilder.create((RegistryObject)LodestoneParticleRegistry.SPARKLE_PARTICLE).setColorData(ColorParticleData.create((Color)start, (Color)end).setEasing(Easing.CUBIC_OUT).build()).setTransparencyData(GenericParticleData.create((float)0.5f, (float)0.0f).setEasing(Easing.SINE_IN_OUT).build()).setScaleData(GenericParticleData.create((float)size.floatValue(), (float)0.0f).setEasing(Easing.EXPO_OUT).build()).setSpinData(SpinParticleData.createRandomDirection((class_5819)random, (float)0.03f, (float)0.25f).setEasing(Easing.EXPO_IN_OUT).build()).setLifetime(20 + random.method_43048(10)).addMotion(motion.field_1352, motion.field_1351, motion.field_1350).spawn(level, position.field_1352, position.field_1351 + yOffset, position.field_1350);
    }

    private static void spawnWispParticle(class_1937 level, class_243 position, class_243 motion, float alphaStart, float alphaEnd, class_5819 random, String hex_start, String hex_end, Float size) {
        Color start = ColourMagic.hex2Rgb(hex_start);
        Color end = ColourMagic.hex2Rgb(hex_end);
        WorldParticleBuilder.create((RegistryObject)LodestoneParticleRegistry.WISP_PARTICLE).setColorData(ColorParticleData.create((Color)start, (Color)end).setEasing(Easing.CUBIC_IN_OUT).build()).setTransparencyData(GenericParticleData.create((float)alphaStart, (float)alphaEnd).setEasing(Easing.QUAD_OUT).build()).setScaleData(GenericParticleData.create((float)0.3f, (float)size.floatValue(), (float)0.0f).setEasing(Easing.QUAD_IN_OUT).build()).setSpinData(SpinParticleData.createRandomDirection((class_5819)random, (float)0.03f, (float)0.25f).setEasing(Easing.EXPO_IN_OUT).build()).setLifetime(35 + random.method_43048(15)).addMotion(motion.field_1352, motion.field_1351, motion.field_1350).spawn(level, position.field_1352, position.field_1351, position.field_1350);
    }

    private static void spawnSparkParticle(class_1937 level, class_243 position, class_243 motion, float alphaStart, float alphaEnd, class_5819 random, String hex_start, String hex_end, Float size) {
        Color start = ColourMagic.hex2Rgb(hex_start);
        Color end = ColourMagic.hex2Rgb(hex_end);
        WorldParticleBuilder.create((RegistryObject)LodestoneParticleRegistry.SPARK_PARTICLE).setColorData(ColorParticleData.create((Color)start, (Color)end).setEasing(Easing.CUBIC_IN_OUT).build()).setTransparencyData(GenericParticleData.create((float)alphaStart, (float)alphaEnd).setEasing(Easing.QUAD_OUT).build()).setScaleData(GenericParticleData.create((float)0.3f, (float)size.floatValue(), (float)0.0f).setEasing(Easing.QUAD_IN_OUT).build()).setSpinData(SpinParticleData.createRandomDirection((class_5819)random, (float)0.03f, (float)0.25f).setEasing(Easing.EXPO_IN_OUT).build()).setLifetime(35 + random.method_43048(15)).addMotion(motion.field_1352, motion.field_1351, motion.field_1350).spawn(level, position.field_1352, position.field_1351, position.field_1350);
    }

    private static void spawnStarParticle(class_1937 level, class_243 position, class_243 motion, float alphaStart, float alphaEnd, class_5819 random, String hex_start, String hex_end, Float size) {
        Color start = ColourMagic.hex2Rgb(hex_start);
        Color end = ColourMagic.hex2Rgb(hex_end);
        WorldParticleBuilder.create((RegistryObject)LodestoneParticleRegistry.STAR_PARTICLE).setColorData(ColorParticleData.create((Color)start, (Color)end).setEasing(Easing.CUBIC_IN_OUT).build()).setTransparencyData(GenericParticleData.create((float)alphaStart, (float)alphaEnd).setEasing(Easing.QUAD_OUT).build()).setScaleData(GenericParticleData.create((float)0.3f, (float)size.floatValue(), (float)0.0f).setEasing(Easing.QUAD_IN_OUT).build()).setSpinData(SpinParticleData.createRandomDirection((class_5819)random, (float)0.03f, (float)0.25f).setEasing(Easing.EXPO_IN_OUT).build()).setLifetime(35 + random.method_43048(15)).addMotion(motion.field_1352, motion.field_1351, motion.field_1350).spawn(level, position.field_1352, position.field_1351, position.field_1350);
    }

    private static void spawnTwinkleParticle(class_1937 level, class_243 position, class_243 motion, float alphaStart, float alphaEnd, class_5819 random, String hex_start, String hex_end, Float size) {
        Color start = ColourMagic.hex2Rgb(hex_start);
        Color end = ColourMagic.hex2Rgb(hex_end);
        WorldParticleBuilder.create((RegistryObject)LodestoneParticleRegistry.TWINKLE_PARTICLE).setColorData(ColorParticleData.create((Color)start, (Color)end).setEasing(Easing.SINE_IN_OUT).build()).setTransparencyData(GenericParticleData.create((float)1.0f, (float)0.0f).setEasing(Easing.SINE_IN_OUT).build()).setScaleData(GenericParticleData.create((float)0.1f, (float)size.floatValue(), (float)0.0f).setEasing(Easing.EXPO_OUT).build()).setSpinData(SpinParticleData.createRandomDirection((class_5819)random, (float)0.01f, (float)0.05f).setEasing(Easing.LINEAR).build()).setLifetime(40 + random.method_43048(30)).enableNoClip().addMotion(motion.field_1352, motion.field_1351, motion.field_1350).spawn(level, position.field_1352, position.field_1351, position.field_1350);
    }
}

