StartupEvents.registry('palladium:abilities', (event) => {

    event.create('gravestone:aoe_damage')

        .icon(palladium.createItemIcon('palladium:vibranium_circuit'))
        .documentationDescription('deals damage around the ability user has options to exclude things and or do fire damage if desired as well as give damage credit to the ability user. - thanks nexo')

        .addProperty('radius', 'integer', 10, 'Radius in which surrounding entities will be damaged')
        .addProperty('damage', 'float', 3.0, 'Damage the ability will deal')
		.addProperty('fire_seconds', 'float', 0.0, 'How many seconds the entity should be on fire')
		.addProperty('tag_ex', 'string', 'exclusion_tag', 'Tag that exlcudes entities if desired')

        .tick((entity, entry, holder, enabled) => {
            if (enabled) {
				const tag_ex = entry.getPropertyByName('tag_ex');
				const firetick = entry.getPropertyByName('fire_seconds');
                const damage = entry.getPropertyByName('damage');
                const radius = entry.getPropertyByName('radius') * 2.0;
                //let username = entity.getGameProfile().getName();
                const targets = entity.level.getEntities(entity, AABB.ofSize(entity.position(), 100, 100, 100)).toArray();
				
                for (let j = 0; j < targets.length; j++) {
                        let box = AABB.ofSize(entity.position(), radius, radius, radius);
                        let entities = entity.level.getEntities(entity, box).toArray();
                        for (let i = 0; i < entities.length; i++) {
                            if (entities[i] !== entity && !containsTag(entities[i].getTags().toArray(), tag_ex) && entities[i].type !== "minecraft:item" && entities[i].type !== "minecraft:item_frame" && entities[i].type !== "minecraft:glow_item_frame" && entities[i].type !== "minecraft:armor_stand" && entities[i].type !== "palladium:suit_stand") {
                                entities[i].attack(damage);
								entities[i].setSecondsOnFire(firetick);
                        }
                    }
                }
            }
        })
});
