// made by phantom

StartupEvents.registry('palladium:abilities', (event) => {

    event.create('gravestone:projectile')

        .icon(palladium.createItemIcon('palladium:vibranium_circuit'))
        .documentationDescription('amazing new projectile script. - thanks phantompig')

        .addProperty('velocity', 'float', 5, 'Determines the velocity when shooting the projectile')
		.addProperty('yawOverride', 'float', -999, 'Locks the calculated yaw value to this (setting this to -999 will make it ignored')
		.addProperty('pitchOverride', 'float', -999, 'Locks the calculated pitch value to this (setting this to -999 will make it ignored')
		.addProperty('yawOffset', 'float', -20, 'the value offset for the yaw from the body')
		.addProperty('pitchOffset', 'float', 25, 'the value offset for the pitch from the body')
		.addProperty('yawInaccuracy', 'float', 0, 'how inaccurate the projectiles yaw value is going to be')
		.addProperty('pitchInaccuracy', 'float', 0, 'how inaccurate the projectiles pitch value is going to be')
		.addProperty('entity_type', 'string', 'palladium:custom_projectile', 'Entity type ID for the projectile entity')
		.addProperty('entity_data', 'compound_tag', null, 'Entity NBT data; works the same as the projectile ability')
		.addProperty('count', 'float', 1, 'how many fire when the ability is activated')
		.addProperty('swinging_arm', 'string', 'main_arm', 'Determines which arm(s) should swing upon shooting. Possible values: [none, main_arm, off_arm, right_arm, left_arm, both]')

        .tick((entity, entry, holder, enabled) => {
            if (enabled) {
				var velocity = entry.getPropertyByName('velocity');
				var yawOverride = entry.getPropertyByName('yawOverride');
				var pitchOverride = entry.getPropertyByName('pitchOverride');
				var yawOffset = entry.getPropertyByName('yawOffset');
				var pitchOffset = entry.getPropertyByName('pitchOffset');
				var nbt = entry.getPropertyByName('entity_data');
				let yinaccuracy = entry.getPropertyByName('yawInaccuracy');
				let pinaccuracy = entry.getPropertyByName('pitchInaccuracy');
				let arm = entry.getPropertyByName('swinging_arm');
				let yeet = entry.getPropertyByName('count');
				const type = entry.getPropertyByName('entity_type');

                if (arm == 'main_arm') {
                    entity.swing("MAIN_HAND", true)
                }
                if (arm == 'off_arm') {
                    entity.swing("OFF_HAND", true)
                }
                if (arm == 'right_arm') {
                    entity.swing("RIGHT", true)
                }
                if (arm == 'left_arm') {
                    entity.swing("LEFT", true)
                }
                if (arm == 'both') {
                    entity.swing("RIGHT", true)
                    entity.swing("LEFT", true)
                }

                for (let i = 0; i < yeet; i++) {
                    global.grave_pigfireProjectileAtOffset(
                        entity, // the entity firing the projectile
                        type, // the type of projectile
                        nbt, // any NBT you want the projectile to have; works the same as the projectile ability
                        yawOverride, // don't override the yaw (x angle)
                        pitchOverride, // don't override the pitch (y angle)
                        yawOffset, // to the left
                            pitchOffset, // slightly below eye level
                        velocity, // speed
                        pinaccuracy, // sets the inaccuracy
                        yinaccuracy // sets the inaccuracy
                    );
                }
            }
        })
});

global.toRadians = (deg) => {return deg * (JavaMath.PI / 180)}

global.grave_pigfireProjectileAtOffset = function(entity, type, nbt, yawOverride, pitchOverride, yawOffset, pitchOffset, velocity, pitchinaccuracy, yawinaccuracy) {
    var projectile = entity.block.createEntity(type);
    projectile.mergeNbt(nbt);
    let yawinacc = Math.random() * 2 * yawinaccuracy - yawinaccuracy;
    let pitchinacc = Math.random() * 2 * pitchinaccuracy - pitchinaccuracy;

    var pitch = -global.toRadians(entity.getPitch() + pitchOffset + pitchinacc);
    var yaw = -global.toRadians(entity.getYaw() + yawOffset + yawinacc);

    if (pitchOverride != -999) pitch = global.toRadians(pitchOverride);
    if (yawOverride != -999) yaw = global.toRadians(yawOverride);

    var x = entity.getX() + Math.cos(pitch) * Math.sin(yaw),
    y = entity.getY() + entity.getEyeHeight() + Math.sin(pitch),
    z = entity.getZ() + Math.cos(pitch) * Math.cos(yaw);
    
    projectile.setPos(x, y, z)
    // take a look at all this stuff, its really weird that its crashing for pezzo :think:
    projectile.setRotation(-entity.getYaw(), -entity.getPitch())
    //projectile.shootFromRotation(entity, entity.getXRot(), entity.getYRot(), 0, velocity, inaccuracy);
    projectile.setDeltaMovement(entity.getLookAngle().scale(velocity))

    projectile.setOwner(entity)
    projectile.spawn()
}