let $ClientboundSetEntityMotionPacket = Java.loadClass('net.minecraft.network.protocol.game.ClientboundSetEntityMotionPacket');
let $ClipContext = Java.loadClass('net.minecraft.world.level.ClipContext')
let $ProjectileUtil = Java.loadClass('net.minecraft.world.entity.projectile.ProjectileUtil')
let $Registries = Java.loadClass('net.minecraft.core.registries.Registries')
let $TagKey = Java.loadClass('net.minecraft.tags.TagKey')

let targetEntity;

StartupEvents.registry('palladium:abilities', (EventHandler) => {
    EventHandler
        .create('gravestone:telekinesis')
        .icon(palladium.createItemIcon('minecraft:blaze_rod'))
        .documentationDescription('Entity Targeter/Falling Block Generator inspired by Hazender - VenWhoVian')
        
        .addProperty('allowed_blocks', 'string', 'grave.ht:magnetic', 'block tags for allowed blocks')
        .addProperty('banned_entities', 'string', 'grave.ht:magnetic_entities', 'entity tags for banned entities')
        .addProperty('distance', 'integer', 10, 'Distance in which the player can target entities or blocks')
        .addProperty('grip_score', 'string', 'grave.biot.scroll', 'score used to control the distance of the held entity/block')

        .firstTick((player, entry, enabled) => {
            if (enabled) {
                targetEntity = null
                let distance = entry.getPropertyByName('distance');
                let result = rayTrace(player, distance, 0);
                let { entity: r_Entity, block: r_Block } = result;
                let allowed_blocks = entry.getPropertyByName('allowed_blocks');
                let banned_entities = $TagKey.create($Registries.ENTITY_TYPE, new ResourceLocation(entry.getPropertyByName('banned_entities')));

                if (r_Entity && !r_Entity.entityType.is(banned_entities)) {
                    targetEntity = r_Entity;
                    r_Entity.mergeNbt({
                        Motion:[0.0,0.0,0.0]
                    })
                } else if (r_Block && r_Block.hasTag(allowed_blocks)) {
                    let fallingBlock = player.block.createEntity("minecraft:falling_block");
                    fallingBlock.mergeNbt({
                        BlockState: { Name: r_Block.id },
                        NoGravity: 1,
                        Motion:[0.0,0.0,0.0]
                    });
                    fallingBlock.setPosition(r_Block.x + 0.5, r_Block.y + 0.5, r_Block.z + 0.5);
                    fallingBlock.spawn();
                    targetEntity = fallingBlock;
                    r_Block.set("minecraft:air");
                }
            }
        })
        .tick((player, entry, enabled) => {
        let grip = entry.getPropertyByName('grip_score');
            if (enabled && targetEntity) {
                let distance = palladium.scoreboard.getScore(player, grip, 1);
                doMotion(player, targetEntity, 0.12, distance, 0.5)
            }
        })
});

function rayTrace(entity, distance, inflate) {
    let level = entity.level;
    let eyePos = entity.eyePosition;
    let viewVec = entity.getViewVector(1);
    let endPos = eyePos.add(viewVec.x() * distance, viewVec.y() * distance, viewVec.z() * distance);
    let aabb = AABB.of(eyePos.x(), eyePos.y(), eyePos.z(), endPos.x(), endPos.y(), endPos.z());

    let ray = $ProjectileUtil.getEntityHitResult(level, entity, eyePos, endPos, aabb, (e) => !e.isSpectator(), inflate);
    let clip = new $ClipContext(eyePos, endPos, 'collider', 'none', entity);
    let hit = level.clip(clip);

    if (ray == null || (hit.getBlockPos() && eyePos.distanceTo(hit.getBlockPos()) < eyePos.distanceTo(ray.entity))) {
        return {
            block: hit.getBlockPos() ? level.getBlock(hit.getBlockPos()) : null,
            entity: null
        };
    }
    return {
        block: null,
        entity: ray.entity
    };
}

function doMotion(player, entity, mult, grip_distance, vert_offset, enabled) {
    let lookAngle = player.getLookAngle().scale(grip_distance);
    let playerLocation = Vec3d(
        player.getX(),
        (player.getY() + 1.0),
        player.getZ()
    );
    let targetLocation = Vec3d(
        (playerLocation.x() + lookAngle.x()),
        ((playerLocation.y() + lookAngle.y()) + vert_offset),
        (playerLocation.z() + lookAngle.z())
    );
    let Target = Vec3d(
        (entity.getX() - targetLocation.x()),
        (entity.getY() - targetLocation.y()),
        (entity.getZ() - targetLocation.z())
    ).scale(-1);

    entity.setNoGravity(true);
    if (!enabled) {
        entity.setNoGravity(false);
    }
    entity.resetFallDistance();

    let movement = Target.scale(Target.length() * mult);

    let { minX, maxX, minY, maxY, minZ, maxZ } = entity.getBoundingBox();

                    
    let volume = (maxX - minX) * (maxY - minY) * (maxZ - minZ);

    const maxSpeed = Math.max(0.5, 8 / Math.cbrt(volume));
    if (movement.length() > maxSpeed) {
        movement = movement.normalize().scale(maxSpeed);
    }

    entity.setDeltaMovement(movement);

    if (entity.isPlayer()) {
        entity.connection.send(new $ClientboundSetEntityMotionPacket(entity));
    }
}