/*
 * Decompiled with CFR 0.152.
 */
package dev.willyelton.crystal_tools.client.events;

import dev.willyelton.crystal_tools.client.events.RegisterKeyBindingsEvent;
import dev.willyelton.crystal_tools.client.gui.ModGUIs;
import dev.willyelton.crystal_tools.client.gui.UpgradeScreen;
import dev.willyelton.crystal_tools.common.capability.Capabilities;
import dev.willyelton.crystal_tools.common.capability.Levelable;
import dev.willyelton.crystal_tools.common.network.data.ModeSwitchPayload;
import dev.willyelton.crystal_tools.common.network.data.OpenBackpackPayload;
import dev.willyelton.crystal_tools.common.network.data.TriggerRocketPayload;
import dev.willyelton.crystal_tools.common.network.data.VeinMiningPayload;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import net.neoforged.neoforge.client.network.ClientPacketDistributor;

@EventBusSubscriber(modid="crystal_tools", value={Dist.CLIENT})
public class KeyPressEvent {
    @SubscribeEvent
    public static void handleEventInput(ClientTickEvent.Post event) {
        ItemStack offHandItem;
        ItemStack mainHandItem;
        Minecraft mc = Minecraft.getInstance();
        ClientLevel level = mc.level;
        if (mc.player == null || level == null) {
            return;
        }
        if (RegisterKeyBindingsEvent.UPGRADE_MENU.consumeClick() && !KeyPressEvent.handleUpgradeMenu(mainHandItem = mc.player.getItemInHand(InteractionHand.MAIN_HAND), (Player)mc.player) && !KeyPressEvent.handleUpgradeMenu(offHandItem = mc.player.getItemInHand(InteractionHand.OFF_HAND), (Player)mc.player) && !mainHandItem.isEmpty()) {
            mc.player.displayClientMessage((Component)Component.literal((String)("No Skill Tree Defined for " + mainHandItem.getItemName().getString())).withStyle(ChatFormatting.RED), true);
        }
        if (RegisterKeyBindingsEvent.MODE_SWITCH.consumeClick()) {
            KeyPressEvent.handleModeSwitch(false);
        }
        if (RegisterKeyBindingsEvent.TOGGLE_MAGNET.consumeClick()) {
            KeyPressEvent.handleModeSwitch(true);
        }
        if (RegisterKeyBindingsEvent.OPEN_BACKPACK.consumeClick()) {
            KeyPressEvent.handleOpenBackpack();
        }
        if (RegisterKeyBindingsEvent.TRIGGER_ROCKET.consumeClick()) {
            KeyPressEvent.handleTriggerRocket();
        }
        if (level.getGameTime() % 5L == 0L) {
            ClientPacketDistributor.sendToServer((CustomPacketPayload)new VeinMiningPayload(RegisterKeyBindingsEvent.VEIN_MINE.isDown()), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    public static boolean handleUpgradeMenu(ItemStack stack, Player player) {
        if (stack.isEmpty()) {
            return false;
        }
        Level level = player.level();
        Levelable levelable = (Levelable)stack.getCapability(Capabilities.ITEM_SKILL, (Object)level.registryAccess());
        if (levelable != null) {
            ModGUIs.openScreen(new UpgradeScreen(stack, player, levelable));
            return true;
        }
        return false;
    }

    public static void handleModeSwitch(boolean magnet) {
        ClientPacketDistributor.sendToServer((CustomPacketPayload)new ModeSwitchPayload(Minecraft.getInstance().hasShiftDown(), Minecraft.getInstance().hasControlDown(), Minecraft.getInstance().hasAltDown(), magnet), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public static void handleOpenBackpack() {
        ClientPacketDistributor.sendToServer((CustomPacketPayload)new OpenBackpackPayload(-1), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public static void handleTriggerRocket() {
        ClientPacketDistributor.sendToServer((CustomPacketPayload)new TriggerRocketPayload(), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }
}

