/*
 * Decompiled with CFR 0.152.
 */
package dev.willyelton.crystal_tools.client.events;

import com.mojang.blaze3d.vertex.PoseStack;
import dev.willyelton.crystal_tools.client.config.CrystalToolsClientConfig;
import dev.willyelton.crystal_tools.client.events.RegisterKeyBindingsEvent;
import dev.willyelton.crystal_tools.client.renderer.BlockOverlayRenderer;
import dev.willyelton.crystal_tools.client.renderer.QuarryLaserRenderer;
import dev.willyelton.crystal_tools.common.components.DataComponents;
import dev.willyelton.crystal_tools.common.levelable.tool.LevelableTool;
import dev.willyelton.crystal_tools.common.levelable.tool.VeinMinerLevelableTool;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.state.BlockOutlineRenderState;
import net.minecraft.client.renderer.state.LevelRenderState;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.CustomBlockOutlineRenderer;
import net.neoforged.neoforge.client.event.ExtractBlockOutlineRenderStateEvent;
import net.neoforged.neoforge.client.event.RenderLevelStageEvent;

@EventBusSubscriber(modid="crystal_tools", value={Dist.CLIENT})
public class RenderEvents {
    @SubscribeEvent
    public static void handleRenderLevelStageEvent(RenderLevelStageEvent.AfterWeather event) {
        QuarryLaserRenderer.render((RenderLevelStageEvent)event);
    }

    /*
     * Enabled aggressive block sorting
     */
    @SubscribeEvent
    public static void handleRenderLevelStageEvent(RenderLevelStageEvent.AfterTranslucentBlocks event) {
        Item item;
        if (((Boolean)CrystalToolsClientConfig.DISABLE_BLOCK_TARGET_RENDERING.get()).booleanValue()) {
            return;
        }
        LocalPlayer player = Minecraft.getInstance().player;
        if (player == null) return;
        if (player.isCreative()) return;
        if (player.isSpectator()) return;
        ItemStack stack = player.getItemInHand(InteractionHand.MAIN_HAND);
        if (RegisterKeyBindingsEvent.VEIN_MINE.isDown() && (item = stack.getItem()) instanceof VeinMinerLevelableTool) {
            VeinMinerLevelableTool veinMinerLevelableTool = (VeinMinerLevelableTool)item;
            if ((Integer)stack.getOrDefault(DataComponents.VEIN_MINER, (Object)0) > 0) {
                BlockOverlayRenderer.renderVeinMiner((RenderLevelStageEvent)event, veinMinerLevelableTool, stack);
                return;
            }
        }
        if (!((item = stack.getItem()) instanceof LevelableTool)) return;
        LevelableTool toolItem = (LevelableTool)item;
        if ((Boolean)stack.getOrDefault(DataComponents.HAS_3x3, (Object)false) == false) return;
        if ((Boolean)stack.getOrDefault(DataComponents.DISABLE_3x3, (Object)false) != false) return;
        BlockOverlayRenderer.render3x3((RenderLevelStageEvent)event, toolItem, stack);
    }

    @SubscribeEvent
    public static void handleHighlightEvent(ExtractBlockOutlineRenderStateEvent event) {
        if (((Boolean)CrystalToolsClientConfig.DISABLE_BLOCK_TARGET_RENDERING.get()).booleanValue()) {
            return;
        }
        LocalPlayer player = Minecraft.getInstance().player;
        if (player == null || player.isCreative() || player.isSpectator()) {
            return;
        }
        BlockState state = event.getBlockState();
        ItemStack stack = player.getItemInHand(InteractionHand.MAIN_HAND);
        Item item = stack.getItem();
        if (item instanceof LevelableTool) {
            LevelableTool toolItem = (LevelableTool)item;
            if (((Boolean)stack.getOrDefault(DataComponents.HAS_3x3, (Object)false)).booleanValue() && !((Boolean)stack.getOrDefault(DataComponents.DISABLE_3x3, (Object)false)).booleanValue() && toolItem.isCorrectToolForDrops(stack, state)) {
                event.addCustomRenderer((CustomBlockOutlineRenderer)new BlockVanillaBlockOutline());
            }
        }
    }

    static class BlockVanillaBlockOutline
    implements CustomBlockOutlineRenderer {
        BlockVanillaBlockOutline() {
        }

        public boolean render(BlockOutlineRenderState renderState, MultiBufferSource.BufferSource buffer, PoseStack poseStack, boolean translucentPass, LevelRenderState levelRenderState) {
            return true;
        }
    }
}

