/*
 * Decompiled with CFR 0.152.
 */
package dev.willyelton.crystal_tools.client.gui;

import dev.willyelton.crystal_tools.client.gui.BaseMenuUpgradeScreen;
import dev.willyelton.crystal_tools.common.inventory.container.CrystalFurnaceContainerMenu;
import dev.willyelton.crystal_tools.common.inventory.container.slot.furnace.CrystalFurnaceFuelSlot;
import dev.willyelton.crystal_tools.common.inventory.container.slot.furnace.CrystalFurnaceInputSlot;
import dev.willyelton.crystal_tools.common.inventory.container.slot.furnace.CrystalFurnaceOutputSlot;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.Slot;

public class CrystalFurnaceScreen
extends BaseMenuUpgradeScreen<CrystalFurnaceContainerMenu> {
    private static final ResourceLocation TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"crystal_tools", (String)"textures/gui/crystal_furnace.png");
    private static final int SLOT_TEXTURE_X = 176;
    private static final int SLOT_TEXTURE_Y = 27;
    private static final int SLOT_TEXTURE_SIZE = 18;
    private static final int ARROW_TEXTURE_X = 188;
    private static final int ARROW_TEXTURE_ON_X = 176;
    private static final int ARROW_TEXTURE_Y = 13;
    private static final int ARROW_WIDTH = 12;
    private static final int ARROW_HEIGHT = 14;
    private static final int FIRE_TEXTURE_X = 189;
    private static final int FIRE_TEXTURE_ON_X = 176;
    private static final int FIRE_TEXTURE_Y = 0;
    private static final int FIRE_TEXTURE_WIDTH = 14;
    private static final int FIRE_TEXTURE_HEIGHT = 13;
    private static final int FUEL_ARROW_TEXTURE_X = 176;
    private static final int FUEL_ARROW_TEXTURE_Y = 45;
    private static final int FUEL_ARROW_TEXTURE_WIDTH = 8;
    private static final int FUEL_ARROW_TEXTURE_HEIGHT = 4;
    private static final int FUEL_BAR_X = 28;
    private static final int FUEL_BAR_Y = 91;
    private static final int FUEL_BAR_TEXTURE_X = 0;
    private static final int FUEL_BAR_TEXTURE_Y = 191;
    private static final int FUEL_BAR_INITIAL_WIDTH = 44;
    private static final int FUEL_BAR_HEIGHT = 2;
    private static final int FUEL_BAR_WIDTH_INCREASE = 20;
    private static final int FUEL_INSERT_X = 26;
    private static final int FUEL_INSERT_Y = 86;
    private static final int FUEL_INSERT_TEXTURE_X = 0;
    private static final int FUEL_INSERT_TEXTURE_Y = 201;
    private static final int FUEL_INSERT_WIDTH = 6;
    private static final int FUEL_INSERT_HEIGHT = 5;
    private static final int MAX_COUNTER = 15;
    private static final int MAX_ANIM_FRAME = 3;
    private final NonNullList<Slot> slots;
    private int counter = 0;
    private int animFrame = 0;

    public CrystalFurnaceScreen(CrystalFurnaceContainerMenu container, Inventory inventory, Component name) {
        super(container, inventory, name, ResourceLocation.fromNamespaceAndPath((String)"crystal_tools", (String)"crystal_furnace"));
        this.slots = container.slots;
        this.imageHeight = 191;
        this.inventoryLabelY = this.imageHeight - 94;
    }

    protected void renderBg(GuiGraphics guiGraphics, float pPartialTick, int pMouseX, int pMouseY) {
        guiGraphics.blit(RenderPipelines.GUI_TEXTURED, TEXTURE, this.leftPos, this.topPos, 0.0f, 0.0f, this.imageWidth, this.imageHeight, 256, 256);
        this.renderSlotsTexture(guiGraphics);
        this.renderFuelBar(guiGraphics);
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.render(guiGraphics, mouseX, mouseY, partialTick);
        this.renderTooltip(guiGraphics, mouseX, mouseY);
    }

    private void renderSlotsTexture(GuiGraphics guiGraphics) {
        for (Slot slot : this.slots) {
            int height;
            if (!slot.isActive()) continue;
            guiGraphics.blit(RenderPipelines.GUI_TEXTURED, TEXTURE, slot.x - 1 + this.leftPos, slot.y - 1 + this.topPos, 176.0f, 27.0f, 18, 18, 256, 256);
            if (slot instanceof CrystalFurnaceOutputSlot) {
                guiGraphics.blit(RenderPipelines.GUI_TEXTURED, TEXTURE, slot.x + 3 + this.leftPos, slot.y + 18 + this.topPos, 188.0f, 13.0f, 12, 14, 256, 256);
                float progress = ((CrystalFurnaceContainerMenu)this.menu).getBurnProgress(slot.index - 5);
                height = (int)(progress * 14.0f);
                guiGraphics.blit(RenderPipelines.GUI_TEXTURED, TEXTURE, slot.x + 3 + this.leftPos, slot.y + 18 + this.topPos + 14 - height, 176.0f, (float)(27 - height), 12, height, 256, 256);
                continue;
            }
            if (slot instanceof CrystalFurnaceInputSlot) {
                guiGraphics.blit(RenderPipelines.GUI_TEXTURED, TEXTURE, slot.x + 1 + this.leftPos, slot.y + 18 + this.topPos + 2, 189.0f, 0.0f, 14, 13, 256, 256);
                if (!((CrystalFurnaceContainerMenu)this.menu).isLit()) continue;
                float litProgress = ((CrystalFurnaceContainerMenu)this.menu).getLitProgress();
                height = (int)(litProgress * 13.0f);
                guiGraphics.blit(RenderPipelines.GUI_TEXTURED, TEXTURE, slot.x + 2 + this.leftPos, slot.y + 18 + this.topPos + 13 - height + 2, 176.0f, (float)(13 - height), 14, height, 256, 256);
                continue;
            }
            if (!(slot instanceof CrystalFurnaceFuelSlot) || slot.index == 10) continue;
            guiGraphics.blit(RenderPipelines.GUI_TEXTURED, TEXTURE, slot.x + 4 + this.leftPos, slot.y + 19 + this.topPos, 176.0f, 45.0f, 8, 4, 256, 256);
        }
    }

    private void renderFuelBar(GuiGraphics guiGraphics) {
        if (this.counter > 15) {
            this.counter = 0;
            ++this.animFrame;
            if (this.animFrame > 3) {
                this.animFrame = 0;
            }
        }
        ++this.counter;
        int widthIncrease = (((CrystalFurnaceContainerMenu)this.menu).getNumActiveSlots() - 1) * 20;
        guiGraphics.blit(RenderPipelines.GUI_TEXTURED, TEXTURE, this.leftPos + 28, this.topPos + 91, 0.0f, 191.0f, 44 + widthIncrease, 2, 256, 256);
        if (((CrystalFurnaceContainerMenu)this.menu).isLit()) {
            guiGraphics.blit(RenderPipelines.GUI_TEXTURED, TEXTURE, this.leftPos + 28, this.topPos + 91, 0.0f, (float)(191 + (this.animFrame + 1) * 2), 44 + widthIncrease, 2, 256, 256);
            guiGraphics.blit(RenderPipelines.GUI_TEXTURED, TEXTURE, this.leftPos + 26, this.topPos + 86, (float)(0 + this.animFrame * 6), 201.0f, 6, 5, 256, 256);
        }
    }
}

