/*
 * Decompiled with CFR 0.152.
 */
package dev.willyelton.crystal_tools.client.gui;

import dev.willyelton.crystal_tools.client.gui.BaseMenuUpgradeScreen;
import dev.willyelton.crystal_tools.client.gui.component.EnergyBarWidget;
import dev.willyelton.crystal_tools.common.inventory.container.AbstractGeneratorContainerMenu;
import dev.willyelton.crystal_tools.common.inventory.container.EnergyLevelableContainerMenu;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;

public class CrystalGeneratorScreen
extends BaseMenuUpgradeScreen<AbstractGeneratorContainerMenu> {
    private static final ResourceLocation TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"crystal_tools", (String)"textures/gui/crystal_generator.png");
    private static final int ENERGY_X = 8;
    private static final int ENERGY_Y = 23;
    private static final int ENERGY_WIDTH = 160;
    private static final int ENERGY_HEIGHT = 10;
    private static final int FIRE_X = 82;
    private static final int FIRE_Y = 78;
    private static final int FIRE_WIDTH = 14;
    private static final int FIRE_HEIGHT = 13;
    private static final int FIRE_TEXTURE_ON_X = 176;
    private static final int FIRE_TEXTURE_OFF_X = 190;
    private static final int FIRE_TEXTURE_Y = 0;

    public CrystalGeneratorScreen(AbstractGeneratorContainerMenu container, Inventory inventory, Component title) {
        super(container, inventory, title, ResourceLocation.fromNamespaceAndPath((String)"crystal_tools", (String)"crystal_generator"));
        this.imageHeight = 191;
        this.inventoryLabelY = this.imageHeight - 94;
    }

    protected void renderBg(GuiGraphics guiGraphics, float partialTick, int mouseX, int mouseY) {
        guiGraphics.blit(RenderPipelines.GUI_TEXTURED, this.texture(), this.leftPos, this.topPos, 0.0f, 0.0f, this.imageWidth, this.imageHeight, 256, 256);
        this.renderFire(guiGraphics);
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.render(guiGraphics, mouseX, mouseY, partialTick);
        this.renderTooltip(guiGraphics, mouseX, mouseY);
    }

    @Override
    protected void renderLabels(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        super.renderLabels(guiGraphics, mouseX, mouseY);
        guiGraphics.drawString(this.font, (Component)Component.literal((String)String.format("Generating %s FE/Tick", ((AbstractGeneratorContainerMenu)this.menu).getCurrentGeneration())), this.inventoryLabelX, 39, -12566464, false);
    }

    @Override
    protected void init() {
        super.init();
        this.addRenderableWidget((GuiEventListener)new EnergyBarWidget(this.leftPos + 8, this.topPos + 23, 160, 10, (Component)Component.empty(), this.font, (EnergyLevelableContainerMenu)this.menu));
    }

    protected ResourceLocation texture() {
        return TEXTURE;
    }

    protected int fireX() {
        return 82;
    }

    protected int fireY() {
        return 78;
    }

    private void renderFire(GuiGraphics guiGraphics) {
        guiGraphics.blit(RenderPipelines.GUI_TEXTURED, this.texture(), this.leftPos + this.fireX(), this.topPos + this.fireY(), 190.0f, 0.0f, 14, 13, 256, 256);
        if (((AbstractGeneratorContainerMenu)this.menu).isLit()) {
            float litProgress = ((AbstractGeneratorContainerMenu)this.menu).getLitProgress();
            int height = (int)(litProgress * 13.0f);
            guiGraphics.blit(RenderPipelines.GUI_TEXTURED, this.texture(), this.leftPos + this.fireX(), this.topPos + this.fireY() + 13 - height, 176.0f, (float)(13 - height), 14, height, 256, 256);
        }
    }
}

