/*
 * Decompiled with CFR 0.152.
 */
package dev.willyelton.crystal_tools.client.gui;

import dev.willyelton.crystal_tools.client.gui.BackpackSubScreen;
import dev.willyelton.crystal_tools.client.gui.BaseMenuUpgradeScreen;
import dev.willyelton.crystal_tools.client.gui.BlockEntityUpgradeScreen;
import dev.willyelton.crystal_tools.client.gui.FilterConfigScreen;
import dev.willyelton.crystal_tools.client.gui.ModGUIs;
import dev.willyelton.crystal_tools.client.gui.QuarrySettingsScreen;
import dev.willyelton.crystal_tools.client.gui.SubScreenContainerScreen;
import dev.willyelton.crystal_tools.client.gui.component.EnergyBarWidget;
import dev.willyelton.crystal_tools.client.gui.component.backpack.BackpackScreenButton;
import dev.willyelton.crystal_tools.common.inventory.container.CrystalQuarryContainerMenu;
import dev.willyelton.crystal_tools.common.inventory.container.EnergyLevelableContainerMenu;
import dev.willyelton.crystal_tools.common.inventory.container.LevelableContainerMenu;
import dev.willyelton.crystal_tools.common.inventory.container.subscreen.SubScreenContainerMenu;
import dev.willyelton.crystal_tools.common.levelable.skill.SkillData;
import dev.willyelton.crystal_tools.common.network.data.OpenContainerPayload;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.neoforged.neoforge.client.network.ClientPacketDistributor;

public class CrystalQuarryScreen
extends BaseMenuUpgradeScreen<CrystalQuarryContainerMenu>
implements SubScreenContainerScreen {
    private static final ResourceLocation TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"crystal_tools", (String)"textures/gui/crystal_quarry.png");
    private static final int ENERGY_X = 8;
    private static final int ENERGY_Y = 23;
    private static final int ENERGY_WIDTH = 160;
    private static final int ENERGY_HEIGHT = 10;
    private BackpackScreenButton skillTreeButton;

    public CrystalQuarryScreen(CrystalQuarryContainerMenu container, Inventory inventory, Component title) {
        super(container, inventory, title, ResourceLocation.fromNamespaceAndPath((String)"crystal_tools", (String)"crystal_quarry"));
        this.imageHeight = 227;
        this.inventoryLabelY = this.imageHeight - 97;
    }

    protected void renderBg(GuiGraphics guiGraphics, float partialTick, int mouseX, int mouseY) {
        guiGraphics.blit(RenderPipelines.GUI_TEXTURED, TEXTURE, this.leftPos, this.topPos, 0.0f, 0.0f, this.imageWidth, this.imageHeight, 256, 256);
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.render(guiGraphics, mouseX, mouseY, partialTick);
        this.renderTooltip(guiGraphics, mouseX, mouseY);
    }

    @Override
    protected void renderLabels(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        super.renderLabels(guiGraphics, mouseX, mouseY);
        guiGraphics.drawString(this.font, (Component)Component.literal((String)String.format("Using %s FE/Tick", ((CrystalQuarryContainerMenu)this.menu).getEnergyCost())), this.inventoryLabelX, 39, -12566464, false);
        BlockPos miningAt = ((CrystalQuarryContainerMenu)this.menu).getMiningAt();
        guiGraphics.drawString(this.font, (Component)Component.literal((String)String.format("Mining At %d, %d, %d", miningAt.getX(), miningAt.getY(), miningAt.getZ())), this.inventoryLabelX, 49, -12566464, false);
        this.skillTreeButton.setBadgeCounter(((CrystalQuarryContainerMenu)this.menu).getSkillPoints());
    }

    @Override
    protected void init() {
        super.init();
        this.addRenderableWidget((GuiEventListener)new EnergyBarWidget(this.leftPos + 8, this.topPos + 23, 160, 10, (Component)Component.empty(), this.font, (EnergyLevelableContainerMenu)this.menu));
        int screenButtonY = this.topPos + 22 + 21;
        List subScreenButtons = this.getSideButtons(this.leftPos - 21, screenButtonY, this.width, (SubScreenContainerMenu)this.menu);
        subScreenButtons.forEach(x$0 -> {
            BackpackScreenButton cfr_ignored_0 = (BackpackScreenButton)this.addRenderableWidget((GuiEventListener)x$0);
        });
    }

    @Override
    protected void initUpgradeButton(Holder.Reference<SkillData> skillData) {
        this.skillTreeButton = (BackpackScreenButton)this.addRenderableWidget((GuiEventListener)new BackpackScreenButton(this.leftPos - 21, this.topPos + 22, (Component)Component.literal((String)"Open Skill Tree"), button -> ModGUIs.openScreen(new BlockEntityUpgradeScreen((LevelableContainerMenu)this.menu, ((CrystalQuarryContainerMenu)this.menu).getPlayer(), () -> ClientPacketDistributor.sendToServer((CustomPacketPayload)new OpenContainerPayload(((CrystalQuarryContainerMenu)this.menu).getBlockPos().asLong()), (CustomPacketPayload[])new CustomPacketPayload[0]), (SkillData)skillData.value(), (ResourceKey<SkillData>)skillData.key())), (button, guiGraphics, mouseX, mouseY) -> {
            MutableComponent textComponent = Component.literal((String)"Open Skill Tree");
            guiGraphics.setTooltipForNextFrame(this.font, this.font.split((FormattedText)textComponent, Math.max(this.width / 2 - 43, 170)), mouseX, mouseY);
        }, 40));
    }

    @Override
    public List<BackpackSubScreen<?, ?>> getSubScreens() {
        ArrayList subScreens = new ArrayList();
        if (((CrystalQuarryContainerMenu)this.menu).getFilterRows() > 0) {
            subScreens.add(new FilterConfigScreen<CrystalQuarryContainerMenu, CrystalQuarryScreen>(this, (CrystalQuarryContainerMenu)this.menu, ((CrystalQuarryContainerMenu)this.menu).getPlayer().getInventory(), this, (Component)Component.literal((String)"Trash Filter")){

                @Override
                public Component getButtonName() {
                    return Component.literal((String)"Configure Trash Filters");
                }
            });
        }
        subScreens.add(new QuarrySettingsScreen((CrystalQuarryContainerMenu)this.menu, ((CrystalQuarryContainerMenu)this.menu).getPlayer().getInventory(), this));
        return subScreens;
    }
}

