/*
 * Decompiled with CFR 0.152.
 */
package dev.willyelton.crystal_tools.client.gui.component;

import dev.willyelton.crystal_tools.client.gui.component.CrystalToolsButton;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;

public class BlockEntityUpgradeButton
extends CrystalToolsButton {
    public static final ResourceLocation BUTTON_LOCATION = ResourceLocation.fromNamespaceAndPath((String)"crystal_tools", (String)"textures/gui/furnace_button.png");
    private final boolean hasSkillPoints;

    public BlockEntityUpgradeButton(int x, int y, int width, int height, Component message, Button.OnPress onPress, CrystalToolsButton.OnTooltip onTooltip, boolean hasSkillPoints) {
        super(x, y, width, height, message, onPress, onTooltip);
        this.hasSkillPoints = hasSkillPoints;
    }

    @Override
    protected void blitButton(GuiGraphics guiGraphics, int textureY) {
        guiGraphics.blit(RenderPipelines.GUI_TEXTURED, BUTTON_LOCATION, this.getX(), this.getY(), 0.0f, (float)(textureY * this.height), this.width / 2, this.height, 256, 256);
        guiGraphics.blit(RenderPipelines.GUI_TEXTURED, BUTTON_LOCATION, this.getX() + this.width / 2, this.getY(), (float)(200 - this.width / 2), (float)(textureY * this.height), this.width / 2, this.height, 256, 256);
    }

    @Override
    protected void drawButtonText(GuiGraphics guiGraphics, Font font, int fgColor) {
        guiGraphics.drawCenteredString(font, this.getMessage(), this.getX() + this.width / 2, this.getY() + (this.height - 8) / 2, fgColor | Mth.ceil((float)(this.alpha * 255.0f)) << 24);
    }

    @Override
    protected int getTextureY(boolean pIsHovered) {
        int i = 1;
        if (!this.active) {
            i = 0;
        } else if (pIsHovered && this.hasSkillPoints) {
            i = 4;
        } else if (pIsHovered) {
            i = 2;
        } else if (this.hasSkillPoints) {
            i = 3;
        }
        return i;
    }
}

