/*
 * Decompiled with CFR 0.152.
 */
package dev.willyelton.crystal_tools.client.gui.component;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.NotNull;

public abstract class CrystalToolsButton
extends Button {
    protected final OnTooltip onTooltip;

    public CrystalToolsButton(int x, int y, int width, int height, Component name, Button.OnPress onPress, OnTooltip onToolTip) {
        super(x, y, width, height, name, onPress, DEFAULT_NARRATION);
        this.onTooltip = onToolTip;
    }

    public void renderWidget(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        Minecraft minecraft = Minecraft.getInstance();
        Font font = minecraft.font;
        int textureY = this.getTextureY(this.isHoveredOrFocused());
        this.blitButton(guiGraphics, textureY);
        int j = this.getFGColor();
        this.drawButtonText(guiGraphics, font, j);
        if (this.isHovered()) {
            this.onTooltip.onTooltip(this, guiGraphics, mouseX, mouseY);
        }
    }

    protected abstract void blitButton(GuiGraphics var1, int var2);

    protected abstract void drawButtonText(GuiGraphics var1, Font var2, int var3);

    protected abstract int getTextureY(boolean var1);

    public int getFGColor() {
        return this.active ? 0xFFFFFF : 0xA0A0A0;
    }

    public static interface OnTooltip {
        public void onTooltip(Button var1, GuiGraphics var2, int var3, int var4);
    }
}

