/*
 * Decompiled with CFR 0.152.
 */
package dev.willyelton.crystal_tools.client.gui.component;

import dev.willyelton.crystal_tools.client.gui.component.CrystalToolsButton;
import dev.willyelton.crystal_tools.common.config.CrystalToolsConfig;
import dev.willyelton.crystal_tools.common.levelable.skill.SkillPoints;
import dev.willyelton.crystal_tools.common.levelable.skill.node.SkillDataNode;
import dev.willyelton.crystal_tools.common.levelable.skill.requirement.RequirementType;
import dev.willyelton.crystal_tools.common.levelable.skill.requirement.SkillItemRequirement;
import dev.willyelton.crystal_tools.utils.Colors;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class SkillButton
extends CrystalToolsButton {
    public static final ResourceLocation SKILL_BUTTON_LOCATION = ResourceLocation.fromNamespaceAndPath((String)"crystal_tools", (String)"textures/gui/skill_button.png");
    private static final int ITEM_WIDTH = 16;
    public boolean isComplete = false;
    private final SkillDataNode dataNode;
    public int xOffset = 0;
    public int yOffset = 0;
    private final Player player;
    private final List<SkillItemRequirement> items;
    private final SkillPoints skillPoints;
    private final List<int[]> itemPositions;

    public SkillButton(int x, int y, int width, int height, Component name, Button.OnPress onPress, CrystalToolsButton.OnTooltip onTooltip, SkillDataNode node, Player player, SkillPoints skillPoints) {
        super(x, y, width, height, name, onPress, onTooltip);
        this.dataNode = node;
        this.player = player;
        this.items = node.getRequirements().stream().filter(requirement -> requirement.getRequirementType() == RequirementType.ITEM).map(skillDataRequirement -> (SkillItemRequirement)skillDataRequirement).collect(Collectors.toList());
        this.skillPoints = skillPoints;
        this.itemPositions = new ArrayList<int[]>();
        this.itemPositions.add(new int[]{-8, -8});
        this.itemPositions.add(new int[]{width - 8, -8});
        this.itemPositions.add(new int[]{width - 8, height - 8});
        this.itemPositions.add(new int[]{-8, height - 8});
    }

    @Override
    public void renderWidget(@NotNull GuiGraphics guiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
        if (this.visible) {
            this.isHovered = pMouseX >= this.getX() + this.xOffset && pMouseY >= this.getY() + this.yOffset && pMouseX < this.getX() + this.xOffset + this.width && pMouseY < this.getY() + this.yOffset + this.height;
            super.renderWidget(guiGraphics, pMouseX, pMouseY, pPartialTick);
            if (((Boolean)CrystalToolsConfig.ENABLE_ITEM_REQUIREMENTS.get()).booleanValue() && !this.isComplete) {
                this.renderItems(guiGraphics);
            }
        }
    }

    @Override
    protected void blitButton(GuiGraphics guiGraphics, int textureY) {
        guiGraphics.blit(RenderPipelines.GUI_TEXTURED, SKILL_BUTTON_LOCATION, this.getX() + this.xOffset, this.getY() + this.yOffset, 0.0f, (float)(textureY * 20), this.width / 2, this.height, 256, 256);
        guiGraphics.blit(RenderPipelines.GUI_TEXTURED, SKILL_BUTTON_LOCATION, this.getX() + this.width / 2 + this.xOffset, this.getY() + this.yOffset, (float)(200 - this.width / 2), (float)(textureY * 20), this.width / 2, this.height, 256, 256);
    }

    @Override
    protected void drawButtonText(GuiGraphics guiGraphics, Font font, int fgColor) {
        guiGraphics.drawCenteredString(font, this.getMessage(), this.getX() + this.width / 2 + this.xOffset, this.getY() + (this.height - 8) / 2 + this.yOffset, fgColor | Mth.ceil((float)(this.alpha * 255.0f)) << 24);
    }

    @Override
    public int getTextureY(boolean hovered) {
        boolean isInfinite = this.dataNode.getLimit() != 1;
        int points = this.skillPoints.getPoints(this.dataNode.getId());
        if (isInfinite && points > 0) {
            if (!this.isActive()) {
                return 3;
            }
            if (hovered) {
                return 6;
            }
            return 5;
        }
        if (this.isComplete) {
            return 3;
        }
        if (!this.isActive()) {
            return 0;
        }
        if (hovered) {
            return 2;
        }
        return 1;
    }

    public void setComplete() {
        this.isComplete = true;
        this.active = false;
    }

    public SkillDataNode getDataNode() {
        return this.dataNode;
    }

    public boolean isMouseOver(double pMouseX, double pMouseY) {
        return this.active && this.visible && pMouseX >= (double)(this.getX() + this.xOffset) && pMouseY >= (double)(this.getY() + this.yOffset) && pMouseX < (double)(this.getX() + this.width + this.xOffset) && pMouseY < (double)(this.getY() + this.height + this.yOffset);
    }

    private void renderItem(GuiGraphics guiGraphics, ItemStack itemStack, int x, int y, boolean canLevel) {
        guiGraphics.renderItem(itemStack, x, y);
        int color = canLevel ? Colors.fromRGB(0, 255, 0, 50) : Colors.fromRGB(255, 0, 0, 50);
        guiGraphics.fill(x, y, x + 16, y + 16, color);
    }

    private void renderItems(GuiGraphics guiGraphics) {
        int i = 0;
        block0: for (SkillItemRequirement req : this.items) {
            for (Item item : req.getItems()) {
                this.renderItem(guiGraphics, item.getDefaultInstance(), this.getX() + this.xOffset + this.itemPositions.get(i)[0], this.getY() + this.yOffset + this.itemPositions.get(i)[1], req.hasItem(this.player, item));
                if (++i <= 3) continue;
                continue block0;
            }
        }
    }
}

