/*
 * Decompiled with CFR 0.152.
 */
package dev.willyelton.crystal_tools.client.gui.component;

import dev.willyelton.crystal_tools.client.gui.component.CrystalToolsButton;
import dev.willyelton.crystal_tools.utils.Colors;
import dev.willyelton.crystal_tools.utils.XpUtils;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;

public class XpButton
extends Button {
    private static final ResourceLocation TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"crystal_tools", (String)"textures/gui/xp_button.png");
    protected final CrystalToolsButton.OnTooltip onTooltip;
    protected final Supplier<Integer> levelCostSupplier;

    public XpButton(int x, int y, int width, int height, Button.OnPress onPress, CrystalToolsButton.OnTooltip onToolTip, Supplier<Integer> levelCostSupplier) {
        super(x, y, width, height, (Component)Component.literal((String)String.valueOf(levelCostSupplier.get())), onPress, DEFAULT_NARRATION);
        this.onTooltip = onToolTip;
        this.levelCostSupplier = levelCostSupplier;
    }

    protected void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.renderWidget(guiGraphics, mouseX, mouseY, partialTick);
        guiGraphics.blit(RenderPipelines.GUI_TEXTURED, TEXTURE, this.getX() + 4, this.getY() + 5, 0.0f, 0.0f, 9, 9, 256, 256);
        if (this.isHovered) {
            this.onTooltip.onTooltip(this, guiGraphics, mouseX, mouseY);
        }
    }

    public void renderString(GuiGraphics guiGraphics, Font font, int pColor) {
        int color = this.active ? Colors.fromRGB(200, 255, 143) : Colors.fromRGB(140, 96, 93);
        Component component = this.getMessage();
        int n = this.getX() + 16;
        int n2 = this.getY();
        int n3 = this.getHeight();
        Objects.requireNonNull(font);
        guiGraphics.drawString(font, component, n, n2 + (n3 - 9) / 2 + 1, color);
    }

    public Component getMessage() {
        return Component.literal((String)String.valueOf(this.levelCostSupplier.get()));
    }

    public void update(int levelCost, Player player) {
        this.active = XpUtils.getPlayerTotalXp(player) >= (long)levelCost;
        this.setMessage((Component)Component.literal((String)("" + levelCost)));
    }
}

