/*
 * Decompiled with CFR 0.152.
 */
package dev.willyelton.crystal_tools.client.gui.component.backpack;

import dev.willyelton.crystal_tools.client.gui.CrystalBackpackScreen;
import dev.willyelton.crystal_tools.client.gui.component.CrystalToolsButton;
import dev.willyelton.crystal_tools.common.inventory.container.subscreen.SubScreenContainerMenu;
import dev.willyelton.crystal_tools.common.network.data.BackpackScreenPayload;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;

public abstract class BackpackActionButton
extends CrystalToolsButton {
    private static final int BUTTON_SIZE = 12;
    private static final int TEXTURE_Y = 281;
    private final int uOffset;

    public BackpackActionButton(int x, int y, Component name, BackpackScreenPayload.BackpackAction action, int uOffset, Screen screen, SubScreenContainerMenu container) {
        this(x, y, name, button -> container.sendUpdatePacket(action, Minecraft.getInstance().hasShiftDown()), (button, guiGraphics, mouseX, mouseY) -> guiGraphics.setTooltipForNextFrame(screen.getMinecraft().font, screen.getMinecraft().font.split((FormattedText)name, Math.max(screen.width / 2 - 43, 170)), mouseX, mouseY), uOffset);
    }

    public BackpackActionButton(int x, int y, Component name, Button.OnPress onPress, CrystalToolsButton.OnTooltip onTooltip, int uOffset) {
        super(x, y, 12, 12, name, onPress, onTooltip);
        this.uOffset = uOffset;
    }

    @Override
    protected void blitButton(GuiGraphics guiGraphics, int textureY) {
        guiGraphics.blit(RenderPipelines.GUI_TEXTURED, CrystalBackpackScreen.TEXTURE, this.getX(), this.getY(), (float)this.getUOffset(), (float)textureY, 12, 12, 512, 512);
    }

    @Override
    protected void drawButtonText(GuiGraphics guiGraphics, Font font, int fgColor) {
    }

    @Override
    protected int getTextureY(boolean isHovered) {
        if (this.isHovered) {
            return 293;
        }
        return 281;
    }

    protected int getUOffset() {
        return this.uOffset;
    }
}

