/*
 * Decompiled with CFR 0.152.
 */
package dev.willyelton.crystal_tools.client.gui.component.backpack;

import dev.willyelton.crystal_tools.client.gui.CrystalBackpackScreen;
import dev.willyelton.crystal_tools.client.gui.component.CrystalToolsButton;
import dev.willyelton.crystal_tools.utils.Colors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.network.chat.Component;

public class BackpackScreenButton
extends CrystalToolsButton {
    private static final int BUTTON_SIZE = 20;
    private static final int TEXTURE_Y = 335;
    private final int xTextureOffset;
    private final Font font;
    private int badgeCounter = 0;

    public BackpackScreenButton(int x, int y, Component name, Button.OnPress onPress, CrystalToolsButton.OnTooltip onToolTip, int xTextureOffset) {
        super(x, y, 20, 20, name, onPress, onToolTip);
        this.xTextureOffset = xTextureOffset;
        this.font = Minecraft.getInstance().font;
    }

    @Override
    protected void blitButton(GuiGraphics guiGraphics, int textureY) {
        guiGraphics.blit(RenderPipelines.GUI_TEXTURED, CrystalBackpackScreen.TEXTURE, this.getX(), this.getY(), (float)this.xTextureOffset, (float)textureY, 20, 20, 512, 512);
        if (this.badgeCounter > 0) {
            String badgeCounterString = String.valueOf(this.badgeCounter);
            int xOffset = this.font.width(badgeCounterString);
            int badgeWidth = xOffset + xOffset % 2 + 4;
            guiGraphics.blit(RenderPipelines.GUI_TEXTURED, CrystalBackpackScreen.TEXTURE, this.getX() - badgeWidth + 2 + 5, this.getY() - 3, 0.0f, 375.0f, badgeWidth / 2, 10, 512, 512);
            guiGraphics.blit(RenderPipelines.GUI_TEXTURED, CrystalBackpackScreen.TEXTURE, this.getX() - badgeWidth / 2 + 7, this.getY() - 3, 66.0f - (float)badgeWidth / 2.0f, 375.0f, badgeWidth / 2, 10, 512, 512);
            guiGraphics.drawString(Minecraft.getInstance().font, badgeCounterString, this.getX() - xOffset + 5, this.getY() - 2, Colors.fromRGB(255, 255, 255), true);
        }
    }

    @Override
    protected void drawButtonText(GuiGraphics guiGraphics, Font font, int fgColor) {
    }

    @Override
    protected int getTextureY(boolean isHovered) {
        if (this.isHovered) {
            return 355;
        }
        return 335;
    }

    public void setBadgeCounter(int badgeCounter) {
        this.badgeCounter = badgeCounter;
    }
}

