/*
 * Decompiled with CFR 0.152.
 */
package dev.willyelton.crystal_tools.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.serialization.MapCodec;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.client.model.Model;
import net.minecraft.client.model.ShieldModel;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.blockentity.BannerRenderer;
import net.minecraft.client.renderer.special.SpecialModelRenderer;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.MaterialSet;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponents;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Unit;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BannerPatternLayers;
import org.joml.Vector3f;

public class CrystalShieldRenderer
implements SpecialModelRenderer<DataComponentMap> {
    private static final Material SHIELD_MATERIAL = new Material(Sheets.SHIELD_SHEET, ResourceLocation.fromNamespaceAndPath((String)"crystal_tools", (String)"entity/crystal_shield"));
    private final ShieldModel shieldModel;
    private final MaterialSet materials;

    public CrystalShieldRenderer(MaterialSet materials, ShieldModel shieldModel) {
        this.materials = materials;
        this.shieldModel = shieldModel;
    }

    @Nullable
    public DataComponentMap extractArgument(ItemStack stack) {
        return stack.immutableComponents();
    }

    public void submit(DataComponentMap components, ItemDisplayContext itemDisplayContext, PoseStack poseStack, SubmitNodeCollector nodeCollector, int p_386748_, int p_388858_, boolean p_387642_, int p_451675_) {
        BannerPatternLayers bannerpatternlayers = components != null ? (BannerPatternLayers)components.getOrDefault(DataComponents.BANNER_PATTERNS, (Object)BannerPatternLayers.EMPTY) : BannerPatternLayers.EMPTY;
        DyeColor dyecolor = components != null ? (DyeColor)components.get(DataComponents.BASE_COLOR) : null;
        boolean hasBanner = !bannerpatternlayers.layers().isEmpty() || dyecolor != null;
        poseStack.pushPose();
        poseStack.scale(1.0f, -1.0f, -1.0f);
        Material material = SHIELD_MATERIAL;
        nodeCollector.submitModelPart(this.shieldModel.handle(), poseStack, this.shieldModel.renderType(material.atlasLocation()), p_386748_, p_388858_, this.materials.get(material), false, false, -1, null, p_451675_);
        if (hasBanner) {
            BannerRenderer.submitPatterns((MaterialSet)this.materials, (PoseStack)poseStack, (SubmitNodeCollector)nodeCollector, (int)p_386748_, (int)p_388858_, (Model)this.shieldModel, (Object)Unit.INSTANCE, (Material)material, (boolean)false, (DyeColor)Objects.requireNonNullElse(dyecolor, DyeColor.WHITE), (BannerPatternLayers)bannerpatternlayers, (boolean)p_387642_, null, (int)p_451675_);
        } else {
            nodeCollector.submitModelPart(this.shieldModel.plate(), poseStack, this.shieldModel.renderType(material.atlasLocation()), p_386748_, p_388858_, this.materials.get(material), false, p_387642_, -1, null, p_451675_);
        }
    }

    public void getExtents(Set<Vector3f> vectors) {
        PoseStack posestack = new PoseStack();
        posestack.scale(1.0f, -1.0f, -1.0f);
        this.shieldModel.root().getExtentsForGui(posestack, vectors);
    }

    public record Unbaked() implements SpecialModelRenderer.Unbaked
    {
        public static final Unbaked INSTANCE = new Unbaked();
        public static final MapCodec<Unbaked> MAP_CODEC = MapCodec.unit((Object)INSTANCE);

        public MapCodec<Unbaked> type() {
            return MAP_CODEC;
        }

        public SpecialModelRenderer<?> bake(SpecialModelRenderer.BakingContext context) {
            return new CrystalShieldRenderer(context.materials(), new ShieldModel(context.entityModelSet().bakeLayer(ModelLayers.SHIELD)));
        }
    }
}

