/*
 * Decompiled with CFR 0.152.
 */
package dev.willyelton.crystal_tools.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import dev.willyelton.crystal_tools.common.entity.CrystalTridentEntity;
import java.util.List;
import net.minecraft.client.model.Model;
import net.minecraft.client.model.TridentModel;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.entity.state.EntityRenderState;
import net.minecraft.client.renderer.entity.state.ThrownTridentRenderState;
import net.minecraft.client.renderer.state.CameraRenderState;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Unit;
import net.minecraft.world.entity.Entity;
import org.joml.Quaternionfc;

public class CrystalTridentRenderer
extends EntityRenderer<CrystalTridentEntity, ThrownTridentRenderState> {
    public static final ResourceLocation CRYSTAL_TRIDENT_LOCATION = ResourceLocation.fromNamespaceAndPath((String)"crystal_tools", (String)"textures/entity/crystal_trident.png");
    private final TridentModel model;

    public CrystalTridentRenderer(EntityRendererProvider.Context context) {
        super(context);
        this.model = new TridentModel(context.bakeLayer(ModelLayers.TRIDENT));
    }

    public void submit(ThrownTridentRenderState renderState, PoseStack poseStack, SubmitNodeCollector nodeCollector, CameraRenderState cameraRenderState) {
        poseStack.pushPose();
        poseStack.mulPose((Quaternionfc)Axis.YP.rotationDegrees(renderState.yRot - 90.0f));
        poseStack.mulPose((Quaternionfc)Axis.ZP.rotationDegrees(renderState.xRot + 90.0f));
        List list = ItemRenderer.getFoilRenderTypes((RenderType)this.model.renderType(CRYSTAL_TRIDENT_LOCATION), (boolean)false, (boolean)false);
        for (int i = 0; i < list.size(); ++i) {
            nodeCollector.order(i).submitModel((Model)this.model, (Object)Unit.INSTANCE, poseStack, (RenderType)list.get(i), renderState.lightCoords, OverlayTexture.NO_OVERLAY, -1, null, renderState.outlineColor, null);
        }
        poseStack.popPose();
        super.submit((EntityRenderState)renderState, poseStack, nodeCollector, cameraRenderState);
    }

    public ThrownTridentRenderState createRenderState() {
        return new ThrownTridentRenderState();
    }

    public void extractRenderState(CrystalTridentEntity entity, ThrownTridentRenderState reusedState, float partialTick) {
        super.extractRenderState((Entity)entity, (EntityRenderState)reusedState, partialTick);
        reusedState.yRot = entity.getYRot();
        reusedState.xRot = entity.getXRot();
    }
}

