/*
 * Decompiled with CFR 0.152.
 */
package dev.willyelton.crystal_tools.client.renderer;

import com.mojang.math.Axis;
import dev.willyelton.crystal_tools.client.renderer.CrystalToolsRenderTypes;
import dev.willyelton.crystal_tools.client.renderer.blockentity.CrystalQuarryBlockEntityRenderer;
import net.minecraft.client.model.Model;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.entity.EndCrystalRenderer;
import net.minecraft.resources.ResourceLocation;
import org.joml.Quaternionf;

public class QuarryCubeModel
extends Model<CrystalQuarryBlockEntityRenderer.QuarryRenderState> {
    public static ModelLayerLocation LOCATION = new ModelLayerLocation(ResourceLocation.fromNamespaceAndPath((String)"crystal_tools", (String)"quarry_cube"), "main");
    private static final float SIN_45 = (float)Math.sin(0.7853981633974483);
    private static final float PI_3 = 1.0471976f;
    private static final float PI_180 = (float)Math.PI / 180;
    private final ModelPart cube;
    private final ModelPart outerGlass;
    private final ModelPart innerGlass;

    public QuarryCubeModel(ModelPart root) {
        super(root, rl -> CrystalToolsRenderTypes.QUARRY_CUBE);
        this.outerGlass = root.getChild("outer_glass");
        this.innerGlass = this.outerGlass.getChild("inner_glass");
        this.cube = this.innerGlass.getChild("cube");
    }

    public void setupAnim(CrystalQuarryBlockEntityRenderer.QuarryRenderState renderState) {
        super.setupAnim((Object)renderState);
        float f = (float)renderState.ageInTicks * 3.0f;
        float f1 = EndCrystalRenderer.getY((float)renderState.ageInTicks) * 16.0f;
        this.outerGlass.y += f1 / 2.0f;
        this.outerGlass.rotateBy(Axis.YP.rotationDegrees(f).rotateAxis(1.0471976f, SIN_45, 0.0f, SIN_45));
        this.innerGlass.rotateBy(new Quaternionf().setAngleAxis(1.0471976f, SIN_45, 0.0f, SIN_45).rotateY(f * ((float)Math.PI / 180)));
        this.cube.rotateBy(new Quaternionf().setAngleAxis(1.0471976f, SIN_45, 0.0f, SIN_45).rotateY(f * ((float)Math.PI / 180)));
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        float f = 0.875f;
        CubeListBuilder cubelistbuilder = CubeListBuilder.create().texOffs(0, 0).addBox(-4.0f, -4.0f, -4.0f, 8.0f, 8.0f, 8.0f);
        PartDefinition partdefinition1 = partdefinition.addOrReplaceChild("outer_glass", cubelistbuilder, PartPose.offset((float)0.0f, (float)24.0f, (float)0.0f));
        PartDefinition partdefinition2 = partdefinition1.addOrReplaceChild("inner_glass", cubelistbuilder, PartPose.ZERO.withScale(0.875f));
        partdefinition2.addOrReplaceChild("cube", CubeListBuilder.create().texOffs(32, 0).addBox(-4.0f, -4.0f, -4.0f, 8.0f, 8.0f, 8.0f), PartPose.ZERO.withScale(0.765625f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)16);
    }
}

