/*
 * Decompiled with CFR 0.152.
 */
package dev.willyelton.crystal_tools.client.renderer.blockentity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import dev.willyelton.crystal_tools.common.levelable.block.CrystalPedestalBlock;
import dev.willyelton.crystal_tools.common.levelable.block.entity.CrystalPedestalBlockEntity;
import dev.willyelton.crystal_tools.common.levelable.block.entity.data.PedestalClientData;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.blockentity.state.BlockEntityRenderState;
import net.minecraft.client.renderer.entity.ItemEntityRenderer;
import net.minecraft.client.renderer.entity.state.ItemClusterRenderState;
import net.minecraft.client.renderer.feature.ModelFeatureRenderer;
import net.minecraft.client.renderer.item.ItemModelResolver;
import net.minecraft.client.renderer.state.CameraRenderState;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionfc;

public class CrystalPedestalBlockEntityRenderer
implements BlockEntityRenderer<CrystalPedestalBlockEntity, PedestalRenderState> {
    private final ItemModelResolver itemModelResolver;
    private final RandomSource random = RandomSource.create();

    public CrystalPedestalBlockEntityRenderer(BlockEntityRendererProvider.Context context) {
        this.itemModelResolver = context.itemModelResolver();
    }

    public PedestalRenderState createRenderState() {
        return new PedestalRenderState();
    }

    public void extractRenderState(CrystalPedestalBlockEntity blockEntity, PedestalRenderState renderState, float partialTick, Vec3 cameraPos, @Nullable ModelFeatureRenderer.CrumblingOverlay overlay) {
        super.extractRenderState((BlockEntity)blockEntity, (BlockEntityRenderState)renderState, partialTick, cameraPos, overlay);
        ItemStack stack = blockEntity.getStack();
        if (stack != null && !stack.isEmpty() && blockEntity.hasLevel()) {
            PedestalClientData clientData = blockEntity.getClientData();
            renderState.displayItem = new ItemClusterRenderState();
            this.itemModelResolver.updateForTopItem(renderState.displayItem.item, stack, ItemDisplayContext.GROUND, blockEntity.getLevel(), null, 0);
            renderState.displayItem.count = ItemClusterRenderState.getRenderedAmount((int)stack.getCount());
            renderState.displayItem.seed = ItemClusterRenderState.getSeedForItemStack((ItemStack)stack);
            renderState.spin = Mth.rotLerp((float)partialTick, (float)clientData.previousRot(), (float)clientData.currentRot());
            renderState.height = Mth.lerp((float)partialTick, (float)clientData.previousHeight(), (float)clientData.currentHeight());
            renderState.direction = (Direction)blockEntity.getBlockState().getValue(CrystalPedestalBlock.FACING);
        }
    }

    public void submit(PedestalRenderState renderState, PoseStack poseStack, SubmitNodeCollector nodeCollector, CameraRenderState cameraRenderState) {
        if (renderState.displayItem != null) {
            poseStack.pushPose();
            poseStack.translate(0.5f, 0.5f, 0.5f);
            poseStack.scale(0.5f, 0.5f, 0.5f);
            poseStack.rotateAround((Quaternionfc)renderState.direction.getRotation(), 0.0f, 0.0f, 0.0f);
            poseStack.mulPose((Quaternionfc)Axis.YP.rotationDegrees(renderState.spin));
            poseStack.translate(0.0f, renderState.height, 0.0f);
            ItemEntityRenderer.renderMultipleFromCount((PoseStack)poseStack, (SubmitNodeCollector)nodeCollector, (int)renderState.lightCoords, (ItemClusterRenderState)renderState.displayItem, (RandomSource)this.random);
            poseStack.popPose();
        }
    }

    public static class PedestalRenderState
    extends BlockEntityRenderState {
        public ItemClusterRenderState displayItem;
        public float spin;
        public float height;
        public Direction direction;
    }
}

