/*
 * Decompiled with CFR 0.152.
 */
package dev.willyelton.crystal_tools.client.renderer.blockentity;

import com.mojang.blaze3d.vertex.PoseStack;
import dev.willyelton.crystal_tools.client.renderer.CrystalToolsRenderTypes;
import dev.willyelton.crystal_tools.client.renderer.QuarryCubeModel;
import dev.willyelton.crystal_tools.common.levelable.block.entity.CrystalQuarryBlockEntity;
import dev.willyelton.crystal_tools.utils.Colors;
import java.util.List;
import net.minecraft.client.model.Model;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.blockentity.state.BlockEntityRenderState;
import net.minecraft.client.renderer.feature.ModelFeatureRenderer;
import net.minecraft.client.renderer.state.CameraRenderState;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class CrystalQuarryBlockEntityRenderer
implements BlockEntityRenderer<CrystalQuarryBlockEntity, QuarryRenderState> {
    private static final int FRAME_COLOR = Colors.fromRGB(48, 231, 237, 255);
    private static final int MINING_COLOR = Colors.fromRGB(0, 144, 180, 255);
    private final QuarryCubeModel model;

    public CrystalQuarryBlockEntityRenderer(BlockEntityRendererProvider.Context context) {
        this.model = new QuarryCubeModel(context.bakeLayer(QuarryCubeModel.LOCATION));
    }

    public QuarryRenderState createRenderState() {
        return new QuarryRenderState();
    }

    public void extractRenderState(CrystalQuarryBlockEntity blockEntity, QuarryRenderState renderState, float partialTick, Vec3 cameraPos, @Nullable ModelFeatureRenderer.CrumblingOverlay overlay) {
        super.extractRenderState((BlockEntity)blockEntity, (BlockEntityRenderState)renderState, partialTick, cameraPos, overlay);
        BlockPos quarryPos = blockEntity.getBlockPos();
        renderState.rotation = ((float)blockEntity.getLevel().getGameTime() + partialTick) * 3.0f;
        renderState.cubePos = new Vec3((double)(blockEntity.getCenterX() - (float)quarryPos.getX()), (double)(blockEntity.getCenterY() - (float)quarryPos.getY()), (double)(blockEntity.getCenterZ() - (float)quarryPos.getZ()));
    }

    public void submit(QuarryRenderState renderState, PoseStack poseStack, SubmitNodeCollector nodeCollector, CameraRenderState cameraRenderState) {
        BlockPos miningAt = renderState.miningAt;
        if (miningAt != null) {
            BlockPos quarryPos = renderState.quarryPos;
            poseStack.pushPose();
            poseStack.translate(renderState.cubePos);
            nodeCollector.submitModel((Model)this.model, (Object)renderState, poseStack, CrystalToolsRenderTypes.QUARRY_CUBE, renderState.lightCoords, OverlayTexture.NO_OVERLAY, -1, null);
            poseStack.popPose();
            Vec3 view = cameraRenderState.pos;
            poseStack.pushPose();
            poseStack.translate((double)(-quarryPos.getX()) + view.x, (double)(-quarryPos.getY()) + view.y, (double)(-quarryPos.getZ()) + view.z);
            float centerX = (float)renderState.centerPos.x();
            float centerY = (float)renderState.centerPos.y();
            float centerZ = (float)renderState.centerPos.z();
            List<BlockPos> corners = renderState.stabilizerPositions;
            if (!corners.isEmpty()) {
                // empty if block
            }
            for (BlockPos blockPos : corners) {
            }
            poseStack.popPose();
        }
    }

    public AABB getRenderBoundingBox(CrystalQuarryBlockEntity blockEntity) {
        return blockEntity.getAABB() == null ? AABB.INFINITE : blockEntity.getAABB();
    }

    public boolean shouldRender(CrystalQuarryBlockEntity blockEntity, Vec3 cameraPos) {
        return !blockEntity.isFinished();
    }

    public boolean shouldRenderOffScreen() {
        return true;
    }

    public static class QuarryRenderState
    extends BlockEntityRenderState {
        public BlockPos miningAt;
        public BlockPos quarryPos;
        public Vec3 cubePos;
        public Vec3 centerPos;
        public float rotation;
        public int ageInTicks;
        public List<BlockPos> stabilizerPositions;
    }
}

