/*
 * Decompiled with CFR 0.152.
 */
package dev.willyelton.crystal_tools.client.renderer.blockentity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import dev.willyelton.crystal_tools.client.renderer.CrystalToolsRenderTypes;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;

public class QuarryCubeRenderer {
    public static ModelLayerLocation LOCATION = new ModelLayerLocation(ResourceLocation.fromNamespaceAndPath((String)"crystal_tools", (String)"quarry_cube"), "main");
    private static final float SIN_45 = (float)Math.sin(0.7853981633974483);
    private static final float PI_3 = 1.0471976f;
    private final ModelPart cube;
    private final ModelPart glass;

    public QuarryCubeRenderer(ModelPart modelPart) {
        this.cube = modelPart.getChild("cube");
        this.glass = modelPart.getChild("glass");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        partdefinition.addOrReplaceChild("glass", CubeListBuilder.create().texOffs(0, 0).addBox(-4.0f, -4.0f, -4.0f, 8.0f, 8.0f, 8.0f), PartPose.ZERO);
        partdefinition.addOrReplaceChild("cube", CubeListBuilder.create().texOffs(32, 0).addBox(-4.0f, -4.0f, -4.0f, 8.0f, 8.0f, 8.0f), PartPose.ZERO);
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)16);
    }

    public void render(float rotation, PoseStack poseStack, MultiBufferSource buffer, int packedLight, float x, float y, float z) {
        poseStack.pushPose();
        VertexConsumer vertexconsumer = buffer.getBuffer(CrystalToolsRenderTypes.QUARRY_CUBE);
        poseStack.pushPose();
        poseStack.scale(2.0f, 2.0f, 2.0f);
        poseStack.translate(x / 2.0f + 0.25f, y / 2.0f + 0.25f, z / 2.0f + 0.25f);
        int packedOverlay = OverlayTexture.NO_OVERLAY;
        poseStack.mulPose((Quaternionfc)Axis.YP.rotationDegrees(rotation));
        poseStack.mulPose((Quaternionfc)new Quaternionf().setAngleAxis(1.0471976f, SIN_45, 0.0f, SIN_45));
        this.glass.render(poseStack, vertexconsumer, packedLight, packedOverlay);
        poseStack.scale(0.875f, 0.875f, 0.875f);
        poseStack.mulPose((Quaternionfc)new Quaternionf().setAngleAxis(1.0471976f, SIN_45, 0.0f, SIN_45));
        poseStack.mulPose((Quaternionfc)Axis.YP.rotationDegrees(rotation));
        this.glass.render(poseStack, vertexconsumer, packedLight, packedOverlay);
        poseStack.scale(0.875f, 0.875f, 0.875f);
        poseStack.mulPose((Quaternionfc)new Quaternionf().setAngleAxis(1.0471976f, SIN_45, 0.0f, SIN_45));
        poseStack.mulPose((Quaternionfc)Axis.YP.rotationDegrees(rotation));
        this.cube.render(poseStack, vertexconsumer, packedLight, packedOverlay);
        poseStack.popPose();
        poseStack.popPose();
    }
}

