/*
 * Decompiled with CFR 0.152.
 */
package dev.willyelton.crystal_tools.common.capability;

import dev.willyelton.crystal_tools.common.capability.Levelable;
import dev.willyelton.crystal_tools.common.components.DataComponents;
import dev.willyelton.crystal_tools.common.config.CrystalToolsConfig;
import dev.willyelton.crystal_tools.common.datamap.DataMaps;
import dev.willyelton.crystal_tools.common.datamap.SkillTreeData;
import dev.willyelton.crystal_tools.common.levelable.skill.SkillData;
import dev.willyelton.crystal_tools.common.levelable.skill.SkillPoints;
import dev.willyelton.crystal_tools.utils.ToolUtils;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class LevelableStack
implements Levelable {
    private final ItemStack stack;
    @Nullable
    private final SkillData skillData;
    private final SkillPoints points;
    @Nullable
    private final ResourceKey<SkillData> key;
    private final SkillTreeData skillTreeData;

    @Nullable
    public static LevelableStack of(ItemStack stack, @Nullable RegistryAccess registryAccess) {
        if (stack.getMaxStackSize() != 1) {
            return null;
        }
        if (!ToolUtils.hasSkillTree(stack)) {
            return null;
        }
        SkillTreeData skillTreeData = (SkillTreeData)stack.getItemHolder().getData(DataMaps.SKILL_TREES);
        if (skillTreeData == null) {
            return null;
        }
        if (registryAccess == null) {
            return new LevelableStack(stack, null, null, skillTreeData);
        }
        Optional<Holder.Reference<SkillData>> skillData = ToolUtils.getSkillData(registryAccess, skillTreeData.treeLocation());
        return skillData.map(skillDataReference -> new LevelableStack(stack, (SkillData)skillDataReference.value(), (ResourceKey<SkillData>)skillDataReference.key(), skillTreeData)).orElse(null);
    }

    private LevelableStack(ItemStack stack, @Nullable SkillData skillData, @Nullable ResourceKey<SkillData> key, SkillTreeData skillTreeData) {
        this.stack = stack;
        this.skillData = skillData;
        this.points = (SkillPoints)stack.getOrDefault(DataComponents.SKILL_POINT_DATA, (Object)new SkillPoints());
        this.key = key;
        this.skillTreeData = skillTreeData;
    }

    @Override
    public void addExp(Level level, BlockPos blockPos, @Nullable LivingEntity livingEntity, float amount) {
        int experienceCap;
        int newExperience = DataComponents.addToComponent(this.stack, DataComponents.SKILL_EXPERIENCE, (int)(amount * this.skillTreeData.experienceScaling()));
        if (newExperience >= (experienceCap = this.getExperienceCap())) {
            DataComponents.addToComponent(this.stack, DataComponents.SKILL_POINTS, 1);
            level.playSound(null, (double)blockPos.getX(), (double)blockPos.getY(), (double)blockPos.getZ(), SoundEvents.PLAYER_LEVELUP, SoundSource.NEUTRAL, 0.8f, 1.0f);
            if (livingEntity instanceof Player) {
                Player player = (Player)livingEntity;
                player.displayClientMessage((Component)Component.literal((String)("\u00a7b" + this.stack.getItem().getName(this.stack).getString() + " Leveled Up (" + this.getSkillPoints() + " Unspent Points)")), true);
            }
            this.stack.set(DataComponents.SKILL_EXPERIENCE, (Object)Math.max(0, newExperience - experienceCap));
            this.increaseExpCap();
        }
    }

    @Override
    public int getSkillPoints() {
        return (Integer)this.stack.getOrDefault(DataComponents.SKILL_POINTS, (Object)0);
    }

    @Override
    public int getExperienceCap() {
        if (this.stack.has(DataComponents.EXPERIENCE_CAP)) {
            return (Integer)this.stack.getOrDefault(DataComponents.EXPERIENCE_CAP, (Object)0);
        }
        int toReturn = (Integer)CrystalToolsConfig.BASE_EXPERIENCE_CAP.get() + this.skillTreeData.baseExperienceModifier();
        this.stack.set(DataComponents.EXPERIENCE_CAP, (Object)toReturn);
        return toReturn;
    }

    @Override
    @Nullable
    public SkillData getSkillTree() {
        return this.skillData;
    }

    @Override
    public SkillPoints getPointData() {
        return this.points;
    }

    @Override
    @Nullable
    public ResourceKey<SkillData> getKey() {
        return this.key;
    }

    @Override
    public void increaseExpCap(int levelIncrease) {
        int experienceCap = this.getExperienceCap();
        int newCap = ToolUtils.getNewCap(experienceCap, levelIncrease);
        this.stack.set(DataComponents.EXPERIENCE_CAP, (Object)newCap);
    }

    @Override
    public boolean allowReset() {
        return this.skillTreeData.allowReset();
    }

    @Override
    public boolean allowXpLevels() {
        return this.skillTreeData.allowXpLevels();
    }

    public boolean allowRepair() {
        return this.skillTreeData.allowRepair();
    }

    public boolean allowMiningXp() {
        return this.skillTreeData.allowMiningXp();
    }

    public boolean allowDamageXp() {
        return this.skillTreeData.allowDamageXp();
    }
}

