/*
 * Decompiled with CFR 0.152.
 */
package dev.willyelton.crystal_tools.common.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import dev.willyelton.crystal_tools.common.capability.Capabilities;
import dev.willyelton.crystal_tools.common.capability.Levelable;
import dev.willyelton.crystal_tools.common.components.DataComponents;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;

public class AddPointsCommand {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        LiteralArgumentBuilder addPointsCommand = (LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"add_points").requires(commandSourceStack -> commandSourceStack.hasPermission(2))).then(Commands.argument((String)"points", (ArgumentType)IntegerArgumentType.integer((int)0)).executes(commandContext -> AddPointsCommand.addPointsToTool((CommandContext<CommandSourceStack>)commandContext, IntegerArgumentType.getInteger((CommandContext)commandContext, (String)"points"))));
        dispatcher.register(addPointsCommand);
    }

    static int addPointsToTool(CommandContext<CommandSourceStack> commandContext, int points) throws CommandSyntaxException {
        LivingEntity livingEntity;
        ItemStack stack;
        Levelable levelable;
        Entity entity = ((CommandSourceStack)commandContext.getSource()).getEntity();
        if (entity instanceof LivingEntity && (levelable = (Levelable)(stack = (livingEntity = (LivingEntity)entity).getItemInHand(InteractionHand.MAIN_HAND)).getCapability(Capabilities.ITEM_SKILL, (Object)livingEntity.level().registryAccess())) != null) {
            DataComponents.addToComponent(stack, DataComponents.SKILL_POINTS, points);
        }
        return 1;
    }
}

