/*
 * Decompiled with CFR 0.152.
 */
package dev.willyelton.crystal_tools.common.crafting;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.willyelton.crystal_tools.ModRegistration;
import dev.willyelton.crystal_tools.common.components.DataComponents;
import dev.willyelton.crystal_tools.common.levelable.skill.SkillPoints;
import dev.willyelton.crystal_tools.utils.EnchantmentUtils;
import java.util.Optional;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.SmithingRecipeInput;
import net.minecraft.world.item.crafting.SmithingTransformRecipe;
import net.minecraft.world.item.crafting.TransmuteResult;

public class CrystalSmithingRecipe
extends SmithingTransformRecipe {
    public CrystalSmithingRecipe(Optional<Ingredient> template, Ingredient base, Optional<Ingredient> addition, TransmuteResult result) {
        super(template, base, addition, result);
    }

    public ItemStack assemble(SmithingRecipeInput input, HolderLookup.Provider registryAccess) {
        ItemStack result = super.assemble(input, registryAccess);
        int finalPoints = EnchantmentUtils.pointsFromEnchantments(result);
        SkillPoints points = (SkillPoints)result.getOrDefault(DataComponents.SKILL_POINT_DATA, (Object)new SkillPoints());
        result.applyComponents(result.getItem().components());
        result.set(DataComponents.SKILL_POINTS, (Object)(finalPoints += points.getTotalPoints() + (Integer)result.getOrDefault(DataComponents.SKILL_POINTS, (Object)0)));
        return result;
    }

    public RecipeSerializer<SmithingTransformRecipe> getSerializer() {
        return (RecipeSerializer)ModRegistration.CRYSTAL_SMITHING_RECIPE.get();
    }

    public static class Serializer
    implements RecipeSerializer<SmithingTransformRecipe> {
        private static final MapCodec<SmithingTransformRecipe> CODEC = RecordCodecBuilder.mapCodec(p_399419_ -> p_399419_.group((App)Ingredient.CODEC.optionalFieldOf("template").forGetter(SmithingTransformRecipe::templateIngredient), (App)Ingredient.CODEC.fieldOf("base").forGetter(SmithingTransformRecipe::baseIngredient), (App)Ingredient.CODEC.optionalFieldOf("addition").forGetter(SmithingTransformRecipe::additionIngredient), (App)TransmuteResult.CODEC.fieldOf("result").forGetter(p_393285_ -> p_393285_.result)).apply((Applicative)p_399419_, CrystalSmithingRecipe::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, SmithingTransformRecipe> STREAM_CODEC = StreamCodec.composite((StreamCodec)Ingredient.OPTIONAL_CONTENTS_STREAM_CODEC, SmithingTransformRecipe::templateIngredient, (StreamCodec)Ingredient.CONTENTS_STREAM_CODEC, SmithingTransformRecipe::baseIngredient, (StreamCodec)Ingredient.OPTIONAL_CONTENTS_STREAM_CODEC, SmithingTransformRecipe::additionIngredient, (StreamCodec)TransmuteResult.STREAM_CODEC, p_393287_ -> p_393287_.result, CrystalSmithingRecipe::new);

        public MapCodec<SmithingTransformRecipe> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, SmithingTransformRecipe> streamCodec() {
            return STREAM_CODEC;
        }
    }
}

