/*
 * Decompiled with CFR 0.152.
 */
package dev.willyelton.crystal_tools.common.events;

import dev.willyelton.crystal_tools.common.capability.Capabilities;
import dev.willyelton.crystal_tools.common.capability.LevelableStack;
import dev.willyelton.crystal_tools.common.components.DataComponents;
import dev.willyelton.crystal_tools.common.levelable.CrystalBackpack;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSoundPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.minecraft.world.item.crafting.SmeltingRecipe;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.level.BlockDropsEvent;
import net.neoforged.neoforge.event.level.BlockEvent;

@EventBusSubscriber(modid="crystal_tools")
public class BlockEvents {
    @SubscribeEvent
    public static void breakEvent(BlockEvent.BreakEvent event) {
        Player player = event.getPlayer();
        CrystalBackpack.addXpToBackpacks(player, 1);
        Level level = player.level();
        ItemStack stack = player.getItemInHand(InteractionHand.MAIN_HAND);
        LevelableStack levelable = (LevelableStack)stack.getCapability(Capabilities.ITEM_SKILL, (Object)level.registryAccess());
        if (levelable != null && levelable.allowMiningXp()) {
            levelable.addExp(level, event.getPos(), (LivingEntity)player);
        }
    }

    @SubscribeEvent
    public static void dropEvent(BlockDropsEvent event) {
        ItemStack tool = event.getTool();
        if (tool.isEmpty()) {
            return;
        }
        Entity entity = event.getBreaker();
        ServerLevel level = event.getLevel();
        if (entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            List drops = event.getDrops();
            if (((Boolean)tool.getOrDefault(DataComponents.AUTO_SMELT, (Object)false)).booleanValue() && !((Boolean)tool.getOrDefault(DataComponents.DISABLE_AUTO_SMELT, (Object)false)).booleanValue()) {
                for (ItemEntity item : drops) {
                    SingleRecipeInput recipeInput;
                    RecipeManager recipeManager;
                    Optional recipeOptional;
                    ItemStack stack = item.getItem();
                    RecipeManager recipeManager2 = level.recipeAccess();
                    if (!(recipeManager2 instanceof RecipeManager) || !(recipeOptional = (recipeManager = recipeManager2).getRecipeFor(RecipeType.SMELTING, (RecipeInput)(recipeInput = new SingleRecipeInput(stack)), (Level)level)).isPresent()) continue;
                    SmeltingRecipe recipe = (SmeltingRecipe)((RecipeHolder)recipeOptional.get()).value();
                    BlockEvents.popExperience(level, (LivingEntity)player, recipe.experience());
                    ItemStack result = recipe.assemble(recipeInput, (HolderLookup.Provider)level.registryAccess()).copy();
                    result.setCount(stack.getCount() * result.getCount());
                    if (result.is(Items.AIR)) continue;
                    item.setItem(result);
                }
            }
            if (((Boolean)tool.getOrDefault(DataComponents.AUTO_PICKUP, (Object)false)).booleanValue()) {
                boolean pickedUp = false;
                for (ItemEntity item : drops) {
                    ItemStack stack = item.getItem();
                    if (!player.getInventory().add(stack)) {
                        item.setItem(stack);
                        continue;
                    }
                    pickedUp = true;
                }
                if (pickedUp) {
                    player.connection.send((Packet)new ClientboundSoundPacket(Holder.direct((Object)SoundEvents.ITEM_PICKUP), SoundSource.PLAYERS, player.getX(), player.getY(), player.getZ(), 0.2f, (level.random.nextFloat() - level.random.nextFloat()) * 1.4f + 2.0f, level.getRandom().nextLong()));
                }
            }
        }
    }

    private static void popExperience(ServerLevel level, LivingEntity entity, float experience) {
        int fullXp = (int)Math.floor(experience);
        float partialXp = experience - (float)fullXp;
        if (partialXp > 0.0f && Math.random() < (double)partialXp) {
            ExperienceOrb.award((ServerLevel)level, (Vec3)entity.position(), (int)(fullXp + 1));
        } else {
            ExperienceOrb.award((ServerLevel)level, (Vec3)entity.position(), (int)fullXp);
        }
    }
}

