/*
 * Decompiled with CFR 0.152.
 */
package dev.willyelton.crystal_tools.common.events;

import dev.willyelton.crystal_tools.client.events.RegisterKeyBindingsEvent;
import dev.willyelton.crystal_tools.common.capability.Capabilities;
import dev.willyelton.crystal_tools.common.capability.LevelableStack;
import dev.willyelton.crystal_tools.common.components.DataComponents;
import dev.willyelton.crystal_tools.common.levelable.LevelableTooltip;
import dev.willyelton.crystal_tools.utils.EnchantmentUtils;
import dev.willyelton.crystal_tools.utils.ToolUtils;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;

@EventBusSubscriber(modid="crystal_tools")
public class ItemTooltipEvent {
    @SubscribeEvent
    public static void addItemToolTips(net.neoforged.neoforge.event.entity.player.ItemTooltipEvent event) {
        LevelableTooltip levelableTooltip;
        int totemSlots;
        String changeKey;
        String mode;
        int durability;
        int index = 1;
        ItemStack stack = event.getItemStack();
        LevelableStack levelableStack = (LevelableStack)stack.getCapability(Capabilities.ITEM_SKILL, null);
        if (!ToolUtils.hasSkillTree(stack) || levelableStack == null) {
            return;
        }
        List tooltips = event.getToolTip();
        if (((Boolean)stack.getOrDefault(DataComponents.DISABLED, (Object)false)).booleanValue()) {
            tooltips.add(index++, Component.literal((String)"\u00a7c\u00a7lDisabled"));
        }
        if ((durability = stack.getMaxDamage() - stack.getDamageValue()) <= 1 && stack.getMaxDamage() != 1 && stack.getDamageValue() != 0) {
            tooltips.add(index++, Component.literal((String)"\u00a7c\u00a7lBroken"));
        }
        int experience = (Integer)stack.getOrDefault(DataComponents.SKILL_EXPERIENCE, (Object)0);
        int experienceCap = levelableStack.getExperienceCap();
        tooltips.add(index++, Component.literal((String)String.format("%d/%d XP To Next Level", experience, experienceCap)));
        int skillPoints = (Integer)stack.getOrDefault(DataComponents.SKILL_POINTS, (Object)0);
        if (skillPoints > 0) {
            tooltips.add(index++, Component.literal((String)String.format("%d Unspent Skill Points (%s to open skill tree)", skillPoints, RegisterKeyBindingsEvent.UPGRADE_MENU.getKey().getDisplayName().getString())));
        }
        if (((Boolean)stack.getOrDefault(DataComponents.MINE_MODE, (Object)false)).booleanValue() && ((Boolean)stack.getOrDefault(DataComponents.SILK_TOUCH_BONUS, (Object)false)).booleanValue() && (Integer)stack.getOrDefault(DataComponents.FORTUNE_BONUS, (Object)0) > 0) {
            mode = EnchantmentUtils.hasEnchantment(stack, (ResourceKey<Enchantment>)Enchantments.SILK_TOUCH) ? "Silk Touch" : "Fortune";
            changeKey = RegisterKeyBindingsEvent.MODE_SWITCH == null ? "" : " (" + RegisterKeyBindingsEvent.MODE_SWITCH.getKey().getDisplayName().getString() + " to change)";
            tooltips.add(index++, Component.literal((String)("\u00a79Mine Mode: " + mode + changeKey)));
        }
        if (((Boolean)stack.getOrDefault(DataComponents.MINE_MODE, (Object)false)).booleanValue() && ((Boolean)stack.getOrDefault(DataComponents.HAS_3x3, (Object)false)).booleanValue()) {
            mode = (Boolean)stack.getOrDefault(DataComponents.DISABLE_3x3, (Object)false) != false ? "1x1" : "3x3";
            changeKey = RegisterKeyBindingsEvent.MODE_SWITCH == null ? "" : " (Shift + " + RegisterKeyBindingsEvent.MODE_SWITCH.getKey().getDisplayName().getString() + " to change)";
            tooltips.add(index++, Component.literal((String)("\u00a79Break Mode: " + mode + changeKey)));
        }
        if (((Boolean)stack.getOrDefault(DataComponents.MINE_MODE, (Object)false)).booleanValue() && ((Boolean)stack.getOrDefault(DataComponents.AUTO_SMELT, (Object)false)).booleanValue()) {
            boolean enabled = (Boolean)stack.getOrDefault(DataComponents.DISABLE_AUTO_SMELT, (Object)false) == false;
            changeKey = RegisterKeyBindingsEvent.MODE_SWITCH == null ? "" : " (Ctrl + " + RegisterKeyBindingsEvent.MODE_SWITCH.getKey().getDisplayName().getString() + " to toggle)";
            tooltips.add(index++, Component.literal((String)("\u00a79Auto Smelt " + (enabled ? "Enabled" : "Disabled") + changeKey)));
        }
        if (((Boolean)stack.getOrDefault(DataComponents.AUTO_TARGET, (Object)false)).booleanValue()) {
            boolean enabled = (Boolean)stack.getOrDefault(DataComponents.DISABLE_AUTO_TARGET, (Object)false) == false;
            changeKey = RegisterKeyBindingsEvent.MODE_SWITCH == null ? "" : " (Shift + " + RegisterKeyBindingsEvent.MODE_SWITCH.getKey().getDisplayName().getString() + " to toggle)";
            tooltips.add(index++, Component.literal((String)("\u00a79Auto Target " + (enabled ? "Enabled" : "Disabled") + changeKey)));
        }
        if ((totemSlots = ((Integer)stack.getOrDefault(DataComponents.TOTEM_SLOTS, (Object)0)).intValue()) > 0) {
            tooltips.add(index++, Component.literal((String)String.format("\u00a72%d/%d Totems of Undying", stack.getOrDefault(DataComponents.FILLED_TOTEM_SLOTS, (Object)0), totemSlots)));
        }
        if ((levelableTooltip = (LevelableTooltip)stack.get(DataComponents.SKILL_TOOLTIP)) != null) {
            levelableTooltip.addTooltips(tooltips, event.getContext(), event.getFlags(), index);
        }
    }
}

