/*
 * Decompiled with CFR 0.152.
 */
package dev.willyelton.crystal_tools.common.events;

import dev.willyelton.crystal_tools.common.components.DataComponents;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.living.LivingDeathEvent;

@EventBusSubscriber(modid="crystal_tools")
public class PlayerDiedEvent {
    @SubscribeEvent
    public static void handlePlayerDying(LivingDeathEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            if (PlayerDiedEvent.trySave(player.getMainHandItem())) {
                event.setCanceled(true);
                PlayerDiedEvent.triggerTotem(player);
            } else if (PlayerDiedEvent.trySave(player.getOffhandItem())) {
                event.setCanceled(true);
                PlayerDiedEvent.triggerTotem(player);
            }
        }
    }

    private static boolean trySave(ItemStack stack) {
        int charges = (Integer)stack.getOrDefault(DataComponents.FILLED_TOTEM_SLOTS, (Object)0);
        if (charges > 0) {
            DataComponents.addToComponent(stack, DataComponents.FILLED_TOTEM_SLOTS, -1);
            return true;
        }
        return false;
    }

    private static void triggerTotem(Player player) {
        player.setHealth(1.0f);
        player.addEffect(new MobEffectInstance(MobEffects.REGENERATION, 900, 1));
        player.addEffect(new MobEffectInstance(MobEffects.ABSORPTION, 100, 1));
        player.addEffect(new MobEffectInstance(MobEffects.FIRE_RESISTANCE, 800, 0));
        player.level().broadcastEntityEvent((Entity)player, (byte)35);
    }
}

