/*
 * Decompiled with CFR 0.152.
 */
package dev.willyelton.crystal_tools.common.events;

import dev.willyelton.crystal_tools.ModRegistration;
import dev.willyelton.crystal_tools.common.capability.Capabilities;
import dev.willyelton.crystal_tools.common.capability.Levelable;
import dev.willyelton.crystal_tools.common.components.DataComponents;
import dev.willyelton.crystal_tools.common.inventory.CrystalBackpackInventory;
import dev.willyelton.crystal_tools.common.levelable.CrystalBackpack;
import dev.willyelton.crystal_tools.utils.InventoryUtils;
import dev.willyelton.crystal_tools.utils.ToolUtils;
import java.util.List;
import net.minecraft.util.TriState;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.attachment.AttachmentType;
import net.neoforged.neoforge.event.entity.player.ItemEntityPickupEvent;

@EventBusSubscriber(modid="crystal_tools")
public class PlayerEvents {
    @SubscribeEvent
    public static void handleItemPickupEvent(ItemEntityPickupEvent.Pre event) {
        if (event.getItemEntity().hasPickUpDelay()) {
            return;
        }
        if (((Boolean)event.getItemEntity().getData((AttachmentType)ModRegistration.MAGNET_ITEM.get())).booleanValue() && !event.getPlayer().equals((Object)event.getItemEntity().getOwner())) {
            List<ItemStack> magnetStacks = InventoryUtils.findAll(event.getPlayer(), stack -> stack.is((Item)ModRegistration.CRYSTAL_MAGNET.get()));
            magnetStacks.forEach(stack -> {
                Levelable levelable = (Levelable)stack.getCapability(Capabilities.ITEM_SKILL, null);
                if (levelable != null) {
                    levelable.addExp(event.getPlayer().level(), event.getPlayer().getOnPos(), (LivingEntity)event.getPlayer(), 1.0f);
                }
            });
        }
        List<ItemStack> backpackStacks = CrystalBackpack.findBackpackStacks(event.getPlayer());
        ItemStack stackToInsert = event.getItemEntity().getItem();
        ItemStack original = event.getItemEntity().getItem().copy();
        for (ItemStack backpackStack : backpackStacks) {
            if (!((Boolean)backpackStack.getOrDefault(DataComponents.BACKPACK_AUTO_PICKUP, (Object)false)).booleanValue() || ((Boolean)backpackStack.getOrDefault(DataComponents.PICKUP_DISABLED, (Object)false)).booleanValue()) continue;
            CrystalBackpackInventory inventory = CrystalBackpack.getInventory(backpackStack);
            List<ItemStack> filterStacks = ToolUtils.getFilterItems(backpackStack);
            if (!ToolUtils.matchesFilter(backpackStack, stackToInsert, filterStacks) || !(stackToInsert = inventory.insertStack(stackToInsert)).isEmpty()) continue;
            event.getItemEntity().getItem().setCount(stackToInsert.getCount());
            event.setCanPickup(TriState.TRUE);
            return;
        }
        if (original.getCount() == stackToInsert.getCount()) {
            event.setCanPickup(TriState.DEFAULT);
        } else {
            event.getItemEntity().setItem(stackToInsert);
            event.setCanPickup(TriState.DEFAULT);
        }
    }
}

