/*
 * Decompiled with CFR 0.152.
 */
package dev.willyelton.crystal_tools.common.events;

import dev.willyelton.crystal_tools.common.capability.Capabilities;
import dev.willyelton.crystal_tools.common.capability.Levelable;
import dev.willyelton.crystal_tools.common.components.DataComponents;
import dev.willyelton.crystal_tools.common.events.LevelTickEvent;
import java.util.Collections;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSoundPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.living.LivingShieldBlockEvent;

@EventBusSubscriber(modid="crystal_tools")
public class ShieldBlockEvent {
    @SubscribeEvent
    public static void handleShieldEvent(LivingShieldBlockEvent event) {
        LivingEntity blockingEntity = event.getEntity();
        Entity attackingEntity = event.getDamageSource().getEntity();
        Entity directEntity = event.getDamageSource().getDirectEntity();
        ItemStack stack = blockingEntity.getUseItem();
        Levelable levelable = (Levelable)stack.getCapability(Capabilities.ITEM_SKILL, (Object)blockingEntity.level().registryAccess());
        if (levelable != null && event.getBlocked() && event.getBlockedDamage() > 0.0f) {
            levelable.addExp(blockingEntity.level(), blockingEntity.getOnPos(), blockingEntity, event.getBlockedDamage());
            if (attackingEntity instanceof LivingEntity) {
                LivingEntity targetEntity = (LivingEntity)attackingEntity;
                ShieldBlockEvent.handleTargetEffects(targetEntity, stack, blockingEntity, blockingEntity.level());
            }
            if (directEntity instanceof Projectile) {
                Projectile projectile = (Projectile)directEntity;
                int target = (Integer)stack.getOrDefault(DataComponents.ENTITY_TARGET, (Object)-1);
                if (target != -1) {
                    LevelTickEvent.startTracking(blockingEntity.level(), projectile.getId(), target, projectile.getDeltaMovement().length());
                }
            }
        }
    }

    private static void handleTargetEffects(LivingEntity target, ItemStack stack, LivingEntity blocker, Level level) {
        int thorns;
        if (((Boolean)stack.getOrDefault(DataComponents.FLAMING_SHIELD, (Object)false)).booleanValue()) {
            target.igniteForTicks(100);
        }
        if (((Boolean)stack.getOrDefault(DataComponents.SHIELD_KNOCKBACK, (Object)false)).booleanValue()) {
            if (blocker instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)blocker;
                player.connection.send((Packet)new ClientboundSoundPacket(Holder.direct((Object)((SoundEvent)SoundEvents.WIND_CHARGE_BURST.value())), SoundSource.PLAYERS, blocker.getX(), blocker.getY(), blocker.getZ(), 2.0f, (level.random.nextFloat() - level.random.nextFloat()) * 1.4f + 2.0f, level.getRandom().nextLong()));
            }
            target.push(target.getPosition(0.0f).subtract(blocker.getPosition(0.0f)).add(0.0, 0.5, 0.0));
        }
        if ((thorns = ((Integer)stack.getOrDefault(DataComponents.SHIELD_THORNS, (Object)0)).intValue()) > 0 && Math.random() < (double)thorns * 0.25) {
            target.hurt(level.damageSources().thorns((Entity)blocker), 3.0f);
        }
        List effects = (List)stack.getOrDefault(DataComponents.EFFECTS, Collections.emptyList());
        effects.forEach(arg_0 -> ((LivingEntity)target).addEffect(arg_0));
    }
}

