/*
 * Decompiled with CFR 0.152.
 */
package dev.willyelton.crystal_tools.common.inventory;

import dev.willyelton.crystal_tools.ModRegistration;
import dev.willyelton.crystal_tools.common.components.DataComponents;
import dev.willyelton.crystal_tools.common.inventory.ItemResourceHandlerAdapterModifiable;
import dev.willyelton.crystal_tools.common.inventory.ListComponentItemHandler;
import dev.willyelton.crystal_tools.utils.InventoryUtils;
import it.unimi.dsi.fastutil.ints.Int2IntArrayMap;
import it.unimi.dsi.fastutil.ints.Int2IntMap;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ItemContainerContents;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.transfer.ResourceHandler;
import net.neoforged.neoforge.transfer.access.ItemAccess;
import net.neoforged.neoforge.transfer.item.ItemResource;
import net.neoforged.neoforge.transfer.item.ItemUtil;

public class CrystalBackpackInventory
extends ListComponentItemHandler {
    public CrystalBackpackInventory(int size) {
        super(ItemAccess.forStack((ItemStack)new ItemStack(ModRegistration.CRYSTAL_BACKPACK)), (DataComponentType<List<ItemContainerContents>>)((DataComponentType)DataComponents.BACKPACK_INVENTORY.get()), size);
    }

    public CrystalBackpackInventory(ItemStack stack) {
        super(ItemAccess.forStack((ItemStack)stack), (DataComponentType<List<ItemContainerContents>>)((DataComponentType)DataComponents.BACKPACK_INVENTORY.get()), ((Integer)stack.getOrDefault(DataComponents.CAPACITY, (Object)0) + 1) * 9);
    }

    @Override
    public boolean isValid(int slot, ItemResource resource) {
        return !resource.is((Object)((Item)ModRegistration.CRYSTAL_BACKPACK.get()));
    }

    public ItemStack insertStack(ItemStack stack) {
        return ItemUtil.insertItemReturnRemaining((ResourceHandler)this, (ItemStack)stack, (boolean)false, null);
    }

    public void sort(Level level, SortType sortType) {
        List<ItemStack> stacks = this.getAllStacks();
        stacks.sort(this.getComparator(level, sortType, stacks));
        InventoryUtils.clear(ItemResourceHandlerAdapterModifiable.of((ResourceHandler<ItemResource>)this));
        stacks.forEach(this::insertStack);
    }

    public int getLastStack() {
        for (int i = this.size() - 1; i >= 0; --i) {
            if (((ItemResource)this.getResource(i)).isEmpty()) continue;
            return i;
        }
        return -1;
    }

    private Comparator<ItemStack> getComparator(Level level, SortType type, List<ItemStack> stacks) {
        return switch (type.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> this.quantityComparator(stacks).thenComparing(this.idComparator());
            case 1 -> this.nameComparator().thenComparing(this.idComparator());
            case 2 -> this.modComparator(level).thenComparing(this.idComparator());
            case 3 -> this.idComparator();
        };
    }

    private List<ItemStack> getAllStacks() {
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        for (int i = 0; i < this.size(); ++i) {
            ItemResource resource = (ItemResource)this.getResource(i);
            if (resource.isEmpty()) continue;
            resource.toStack(this.getAmountAsInt(i));
        }
        return stacks;
    }

    private Comparator<ItemStack> quantityComparator(List<ItemStack> stacks) {
        Int2IntArrayMap map = new Int2IntArrayMap();
        for (ItemStack stack : stacks) {
            map.merge(this.getItemId(stack), stack.getCount(), Integer::sum);
        }
        return Comparator.comparingInt(arg_0 -> this.lambda$quantityComparator$0((Int2IntMap)map, arg_0)).reversed();
    }

    private Comparator<ItemStack> nameComparator() {
        return Comparator.comparing(this::getItemName);
    }

    private Comparator<ItemStack> modComparator(Level level) {
        return Comparator.comparing(stack -> this.getItemMod(level, (ItemStack)stack));
    }

    private Comparator<ItemStack> idComparator() {
        return Comparator.comparing(this::getItemId);
    }

    private int getItemQuantity(ItemStack stack, Int2IntMap quantities) {
        return quantities.get(this.getItemId(stack));
    }

    private String getItemName(ItemStack stack) {
        return stack.getDisplayName().getString();
    }

    private String getItemMod(Level level, ItemStack stack) {
        return stack.getItem().getCreatorModId((HolderLookup.Provider)level.registryAccess(), stack);
    }

    private int getItemId(ItemStack stack) {
        return Item.getId((Item)stack.getItem());
    }

    private /* synthetic */ int lambda$quantityComparator$0(Int2IntMap map, ItemStack stack) {
        return this.getItemQuantity(stack, map);
    }

    public static enum SortType {
        QUANTITY,
        NAME,
        MOD,
        ID;

    }
}

