/*
 * Decompiled with CFR 0.152.
 */
package dev.willyelton.crystal_tools.common.inventory;

import dev.willyelton.crystal_tools.CrystalTools;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ItemContainerContents;
import net.neoforged.neoforge.transfer.ItemAccessResourceHandler;
import net.neoforged.neoforge.transfer.access.ItemAccess;
import net.neoforged.neoforge.transfer.item.ItemResource;
import net.neoforged.neoforge.transfer.resource.Resource;
import net.neoforged.neoforge.transfer.transaction.Transaction;
import net.neoforged.neoforge.transfer.transaction.TransactionContext;

public class ListComponentItemHandler
extends ItemAccessResourceHandler<ItemResource> {
    private static final int MAX_CONTENTS_SIZE = 256;
    protected final Item validItem;
    protected final DataComponentType<List<ItemContainerContents>> component;

    public ListComponentItemHandler(ItemAccess itemAccess, DataComponentType<List<ItemContainerContents>> component, int size) {
        super(itemAccess, size);
        this.validItem = itemAccess.getResource().getItem();
        this.component = component;
    }

    protected List<ItemContainerContents> getContents(ItemResource accessResource) {
        return (List)accessResource.getOrDefault(this.component, List.of());
    }

    protected ItemStack getStackFromContents(List<ItemContainerContents> contentsList, int slot) {
        int listIndex = slot / 256;
        if (listIndex >= contentsList.size()) {
            return ItemStack.EMPTY;
        }
        int contextIndex = listIndex % 256;
        ItemContainerContents contents = contentsList.get(listIndex);
        return contextIndex < contents.getSlots() ? contents.getStackInSlot(contextIndex) : ItemStack.EMPTY;
    }

    protected ItemResource getResourceFrom(ItemResource accessResource, int index) {
        if (accessResource.is((Object)this.validItem)) {
            return ItemResource.of((ItemStack)this.getStackFromContents(this.getContents(accessResource), index));
        }
        return ItemResource.EMPTY;
    }

    protected int getAmountFrom(ItemResource accessResource, int index) {
        if (accessResource.is((Object)this.validItem)) {
            return this.getStackFromContents(this.getContents(accessResource), index).getCount();
        }
        return 0;
    }

    protected ItemResource update(ItemResource accessResource, int index, ItemResource newResource, int newAmount) {
        List<ItemContainerContents> contents = this.getContents(accessResource);
        int listIndex = index / 256;
        int thisContentsIndex = listIndex % 256;
        ItemContainerContents thisContent = index >= contents.size() ? ItemContainerContents.EMPTY : contents.get(index);
        int thisContentsSlots = Math.clamp((long)(this.size - listIndex * 256), 0, 256);
        NonNullList list = NonNullList.withSize((int)Math.max(thisContent.getSlots(), thisContentsSlots), (Object)ItemStack.EMPTY);
        thisContent.copyInto(list);
        list.set(thisContentsIndex, (Object)newResource.toStack(newAmount));
        ItemContainerContents newContents = ItemContainerContents.fromItems((List)list);
        List<ItemContainerContents> copiedContents = this.deepCopy(contents);
        if (copiedContents.size() > index) {
            copiedContents.set(index, newContents);
        } else {
            copiedContents.add(newContents);
        }
        return accessResource.with(this.component, copiedContents);
    }

    public boolean isValid(int index, ItemResource resource) {
        return this.itemAccess.getResource().is((Object)this.validItem);
    }

    protected int getCapacity(int index, ItemResource resource) {
        return resource.isEmpty() ? 99 : Math.min(resource.getMaxStackSize(), 99);
    }

    public void set(ItemStack stack, int index, ItemResource resource, int amount) {
        CrystalTools.LOGGER.info("Setting stack " + String.valueOf(stack) + " to " + String.valueOf(resource) + " with amount " + amount);
        try (Transaction tx = Transaction.open(null);){
            ItemResource extractedResource = (ItemResource)this.getResource(index);
            if (!extractedResource.isEmpty()) {
                int extracted = this.extract(index, (Resource)extractedResource, this.getCapacity(index, extractedResource), (TransactionContext)tx);
                CrystalTools.LOGGER.info("Extracted " + extracted + " of " + String.valueOf(extractedResource));
            }
            if (!resource.isEmpty()) {
                int inserted = this.insert(index, (Resource)resource, amount, (TransactionContext)tx);
                CrystalTools.LOGGER.info("Inserted " + inserted + " of " + String.valueOf(resource));
            }
            tx.commit();
        }
    }

    private List<ItemContainerContents> deepCopy(List<ItemContainerContents> containerContents) {
        ArrayList<ItemContainerContents> newContainerContents = new ArrayList<ItemContainerContents>();
        for (ItemContainerContents contents : containerContents) {
            NonNullList newStacks = NonNullList.withSize((int)contents.getSlots(), (Object)ItemStack.EMPTY);
            contents.copyInto(newStacks);
            newContainerContents.add(ItemContainerContents.fromItems((List)newStacks));
        }
        return newContainerContents;
    }
}

