/*
 * Decompiled with CFR 0.152.
 */
package dev.willyelton.crystal_tools.common.inventory;

import com.google.common.base.Predicates;
import dev.willyelton.crystal_tools.ModRegistration;
import dev.willyelton.crystal_tools.common.components.DataComponents;
import dev.willyelton.crystal_tools.common.datamap.GeneratorFuelData;
import dev.willyelton.crystal_tools.common.levelable.block.entity.CrystalGeneratorBlockEntity;
import dev.willyelton.crystal_tools.utils.ItemStackUtils;
import java.util.function.Predicate;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.transfer.ResourceHandler;
import net.neoforged.neoforge.transfer.access.ItemAccess;
import net.neoforged.neoforge.transfer.item.ItemAccessItemHandler;
import net.neoforged.neoforge.transfer.item.ItemResource;
import org.jetbrains.annotations.Nullable;

public class PortableGeneratorInventory
extends ItemAccessItemHandler {
    public static final int MAX_SIZE = 27;
    private final ItemStack generatorStack;
    @Nullable
    private Level level;

    public PortableGeneratorInventory(int size) {
        super(ItemAccess.forStack((ItemStack)new ItemStack(ModRegistration.PORTABLE_GENERATOR)), net.minecraft.core.component.DataComponents.CONTAINER, Math.min(size, 27));
        this.generatorStack = ItemStack.EMPTY.copy();
    }

    public PortableGeneratorInventory(ItemStack stack) {
        super(ItemAccess.forStack((ItemStack)stack), net.minecraft.core.component.DataComponents.CONTAINER, Math.min((Integer)stack.getOrDefault(DataComponents.PORTABLE_GENERATOR_SLOTS, (Object)0) + 1, 27));
        this.generatorStack = stack;
    }

    public boolean isValid(int slot, ItemResource resource) {
        boolean canFit;
        if (resource.isEmpty()) {
            return true;
        }
        boolean bl = canFit = !resource.is(ModRegistration.PORTABLE_GENERATOR) && super.isValid(slot, resource);
        if (this.level == null) {
            return canFit;
        }
        return canFit && PortableGeneratorInventory.canBurn(this.generatorStack, resource.toStack(), this.level);
    }

    public void setLevel(Level level) {
        this.level = level;
    }

    public ItemStack nextItem() {
        return ItemStackUtils.nextFuelItem((ResourceHandler<ItemResource>)this, (Predicate<ItemResource>)Predicates.alwaysTrue());
    }

    public static boolean canBurn(ItemStack generatorStack, ItemStack stack, Level level) {
        GeneratorFuelData newFuelData = CrystalGeneratorBlockEntity.getFuelData(stack, (Boolean)generatorStack.getOrDefault(DataComponents.FOOD_GENERATOR, (Object)false), (Boolean)generatorStack.getOrDefault(DataComponents.METAL_GENERATOR, (Object)false), (Boolean)generatorStack.getOrDefault(DataComponents.GEM_GENERATOR, (Object)false));
        return newFuelData != null || stack.getBurnTime(RecipeType.SMELTING, level.fuelValues()) > 0;
    }
}

