/*
 * Decompiled with CFR 0.152.
 */
package dev.willyelton.crystal_tools.common.inventory.container;

import dev.willyelton.crystal_tools.ModRegistration;
import dev.willyelton.crystal_tools.common.components.DataComponents;
import dev.willyelton.crystal_tools.common.inventory.container.BaseContainerMenu;
import dev.willyelton.crystal_tools.common.inventory.container.slot.backpack.BackpackFilterSlot;
import dev.willyelton.crystal_tools.common.inventory.container.subscreen.FilterContainerMenu;
import dev.willyelton.crystal_tools.common.inventory.container.subscreen.FilterMenuContents;
import dev.willyelton.crystal_tools.common.inventory.container.subscreen.SubScreenContainerMenu;
import dev.willyelton.crystal_tools.common.inventory.container.subscreen.SubScreenType;
import dev.willyelton.crystal_tools.utils.TransferUtils;
import java.util.Objects;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.transfer.ResourceHandler;
import net.neoforged.neoforge.transfer.access.ItemAccess;
import net.neoforged.neoforge.transfer.item.ItemAccessItemHandler;
import net.neoforged.neoforge.transfer.item.ItemResource;

public class CrystalMagnetContainerMenu
extends BaseContainerMenu
implements SubScreenContainerMenu,
FilterContainerMenu {
    public static final int START_Y = 18;
    private static final int START_X = 8;
    public static final int FILTER_SLOTS_PER_ROW = 9;
    private final ItemStack stack;
    private final int filterRows;
    private final FilterMenuContents<CrystalMagnetContainerMenu> filterMenuContents;

    public CrystalMagnetContainerMenu(int containerId, Inventory playerInventory, RegistryFriendlyByteBuf data) {
        this(containerId, playerInventory, (ItemStack)ItemStack.OPTIONAL_STREAM_CODEC.decode((Object)data), data.readInt());
    }

    public CrystalMagnetContainerMenu(int pContainerId, Inventory playerInventory, ItemStack stack, int slotIndex) {
        super((MenuType)ModRegistration.CRYSTAL_MAGNET_CONTAINER.get(), pContainerId, playerInventory, null);
        this.stack = stack;
        this.filterRows = (Integer)stack.getOrDefault(DataComponents.FILTER_CAPACITY, (Object)0);
        this.filterMenuContents = new FilterMenuContents<CrystalMagnetContainerMenu>(this, this.filterRows * 9, (Boolean)stack.getOrDefault(DataComponents.WHITELIST, (Object)true));
        this.setUpPlayerSlots();
        this.setUpFilterSlots();
    }

    private void setUpPlayerSlots() {
        this.layoutPlayerInventorySlots(8, 86);
    }

    private void setUpFilterSlots() {
        if (Objects.nonNull(this.filterMenuContents.getInventory())) {
            int filterRows = this.getFilterRows();
            this.addSlotBox(this.filterMenuContents.getInventory(), TransferUtils.indexModifier(this.filterMenuContents.getInventory()), 0, 8, 18, 9, 18, filterRows, 18, this.filterMenuContents.getFilterSlots(), BackpackFilterSlot::new);
        }
    }

    @Override
    public int getFilterRows() {
        return this.filterRows;
    }

    @Override
    public ResourceHandler<ItemResource> getFilterInventory() {
        if (this.filterRows == 0) {
            return null;
        }
        return new ItemAccessItemHandler(ItemAccess.forStack((ItemStack)this.stack), (DataComponentType)DataComponents.FILTER_INVENTORY.get(), this.filterRows * 9);
    }

    @Override
    public FilterMenuContents<?> getFilterMenuContents() {
        return this.filterMenuContents;
    }

    @Override
    public void closeSubScreen() {
    }

    @Override
    public void openSubScreen(SubScreenType subScreenType) {
    }

    @Override
    public void setWhitelist(boolean whitelist) {
        FilterContainerMenu.super.setWhitelist(whitelist);
        this.stack.set(DataComponents.WHITELIST, (Object)whitelist);
    }

    public ItemStack quickMoveStack(Player player, int index) {
        ItemStack itemstack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(index);
        if (slot.hasItem()) {
            ItemStack itemstack1 = slot.getItem();
            itemstack = itemstack1.copy();
            if (index < 36) {
                return this.filterMenuContents.quickMove(itemstack);
            }
        }
        return itemstack;
    }

    public void clicked(int slotId, int button, ClickType clickType, Player player) {
        if (slotId >= 0) {
            Slot slot = this.getSlot(slotId);
            if (slot instanceof BackpackFilterSlot) {
                BackpackFilterSlot filterSlot = (BackpackFilterSlot)slot;
                if (Objects.isNull(this.filterMenuContents.getInventory()) || clickType == ClickType.THROW || clickType == ClickType.CLONE) {
                    return;
                }
                filterSlot.onClicked(this.getCarried());
            } else {
                super.clicked(slotId, button, clickType, player);
            }
        }
    }

    public boolean stillValid(Player player) {
        return this.stack != null;
    }
}

