/*
 * Decompiled with CFR 0.152.
 */
package dev.willyelton.crystal_tools.common.inventory.container;

import dev.willyelton.crystal_tools.ModRegistration;
import dev.willyelton.crystal_tools.common.inventory.container.EnergyLevelableContainerMenu;
import dev.willyelton.crystal_tools.common.inventory.container.slot.CrystalSlotItemHandler;
import dev.willyelton.crystal_tools.common.inventory.container.slot.NoInsertSlot;
import dev.willyelton.crystal_tools.common.inventory.container.slot.backpack.BackpackFilterSlot;
import dev.willyelton.crystal_tools.common.inventory.container.subscreen.FilterContainerMenu;
import dev.willyelton.crystal_tools.common.inventory.container.subscreen.FilterMenuContents;
import dev.willyelton.crystal_tools.common.inventory.container.subscreen.SubScreenContainerMenu;
import dev.willyelton.crystal_tools.common.inventory.container.subscreen.SubScreenType;
import dev.willyelton.crystal_tools.common.levelable.block.entity.CrystalQuarryBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.transfer.item.ItemStacksResourceHandler;

public class CrystalQuarryContainerMenu
extends EnergyLevelableContainerMenu
implements SubScreenContainerMenu,
FilterContainerMenu {
    private final CrystalQuarryBlockEntity blockEntity;
    private FilterMenuContents<CrystalQuarryContainerMenu> filterMenuContents;
    private final NonNullList<CrystalSlotItemHandler> quarryInventorySlots;
    private final NonNullList<CrystalSlotItemHandler> filterInventorySlots;
    private final NonNullList<CrystalSlotItemHandler> quarrySlots;
    private final int filterRows;

    public CrystalQuarryContainerMenu(int containerId, Level level, BlockPos pos, int filterRows, Inventory playerInventory, ContainerData data) {
        super((MenuType)ModRegistration.CRYSTAL_QUARRY_CONTAINER.get(), containerId, playerInventory, data);
        this.blockEntity = (CrystalQuarryBlockEntity)level.getBlockEntity(pos);
        this.quarryInventorySlots = NonNullList.createWithCapacity((int)36);
        this.filterInventorySlots = NonNullList.createWithCapacity((int)36);
        this.quarrySlots = NonNullList.createWithCapacity((int)27);
        this.filterRows = filterRows;
        if (this.blockEntity == null) {
            return;
        }
        this.layoutPlayerInventorySlots(8, 145, this.quarryInventorySlots, CrystalSlotItemHandler::new);
        this.layoutPlayerInventorySlots(8, 86, this.filterInventorySlots, CrystalSlotItemHandler::new);
        this.filterInventorySlots.forEach(s -> s.setActive(false));
        this.filterMenuContents = new FilterMenuContents<CrystalQuarryContainerMenu>(this, filterRows, true);
        this.addSlotBox(this.blockEntity.getItemHandler(), 0, 8, 59, 9, 18, 3, 18, this.quarrySlots, NoInsertSlot::new);
        this.addSlotBox(this.blockEntity.getFilterItemHandler(), 0, 8, 18, 9, 18, filterRows, 18, this.filterMenuContents.getFilterSlots(), BackpackFilterSlot::new);
        this.filterMenuContents.toggleSlots(false);
    }

    public ItemStack quickMoveStack(Player player, int index) {
        ItemStack itemStack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(index);
        if (slot.hasItem()) {
            ItemStack slotStack = slot.getItem();
            itemStack = slotStack.copy();
            if (index <= 35) {
                return ItemStack.EMPTY;
            }
            if (index <= 71) {
                return this.filterMenuContents.quickMove(itemStack);
            }
            if (index <= 98 && !this.moveItemStackTo(itemStack, 0, 36, true)) {
                return ItemStack.EMPTY;
            }
            if (itemStack.isEmpty()) {
                slot.setByPlayer(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
        }
        return itemStack;
    }

    public boolean stillValid(Player player) {
        if (this.level != null && this.level.getBlockEntity(this.blockEntity.getBlockPos()) != this.blockEntity) {
            return false;
        }
        return player.distanceToSqr((double)this.blockEntity.getBlockPos().getX() + 0.5, (double)this.blockEntity.getBlockPos().getY() + 0.5, (double)this.blockEntity.getBlockPos().getZ() + 0.5) <= 64.0;
    }

    public void clicked(int slotId, int button, ClickType clickType, Player player) {
        Slot slot;
        if (slotId >= 0 && (slot = this.getSlot(slotId)) instanceof BackpackFilterSlot) {
            BackpackFilterSlot filterSlot = (BackpackFilterSlot)slot;
            if (this.filterMenuContents.getInventory() == null || clickType == ClickType.THROW || clickType == ClickType.CLONE) {
                return;
            }
            filterSlot.onClicked(this.getCarried());
            this.blockEntity.setChanged();
            return;
        }
        super.clicked(slotId, button, clickType, player);
    }

    @Override
    public String getBlockType() {
        return "quarry";
    }

    @Override
    public CrystalQuarryBlockEntity getBlockEntity() {
        return this.blockEntity;
    }

    @Override
    public float getCurrentEnergy() {
        return this.data.get(3);
    }

    @Override
    public float getMaxEnergy() {
        return this.data.get(4);
    }

    public BlockPos getMiningAt() {
        return new BlockPos(this.data.get(5), this.data.get(6), this.data.get(7));
    }

    public BlockPos getBlockPos() {
        return this.blockEntity.getBlockPos();
    }

    @Override
    public boolean getWhitelist() {
        return this.data.get(8) == 1;
    }

    @Override
    public void setWhitelist(boolean whitelist) {
        this.data.set(8, whitelist ? 1 : 0);
    }

    @Override
    public int getFilterRows() {
        return this.filterRows;
    }

    public ItemStacksResourceHandler getFilterInventory() {
        return this.blockEntity.getFilterItemHandler();
    }

    @Override
    public FilterMenuContents<?> getFilterMenuContents() {
        return this.filterMenuContents;
    }

    @Override
    public void closeSubScreen() {
        this.filterMenuContents.toggleSlots(false);
        this.quarrySlots.forEach(slot -> slot.setActive(true));
        this.quarryInventorySlots.forEach(slot -> slot.setActive(true));
        this.filterInventorySlots.forEach(slot -> slot.setActive(false));
    }

    @Override
    public void openSubScreen(SubScreenType subScreenType) {
        if (subScreenType == SubScreenType.FILTER) {
            this.filterMenuContents.toggleSlots(true);
            this.filterInventorySlots.forEach(slot -> slot.setActive(true));
        }
        this.quarrySlots.forEach(slot -> slot.setActive(false));
        this.quarryInventorySlots.forEach(slot -> slot.setActive(false));
    }

    public boolean getSetting(int setting) {
        return this.data.get(9 + setting) >= 1;
    }

    public void setSetting(int setting, boolean value) {
        this.data.set(9 + setting, value ? 1 : 0);
    }

    public boolean shouldSettingBeActive(int setting) {
        if (setting == 0) {
            return true;
        }
        return this.data.get(13 + setting) >= 1;
    }

    public int getEnergyCost() {
        return this.data.get(13);
    }

    public boolean clickMenuButton(Player player, int id) {
        boolean newValue = this.data.get(9 + id) == 0;
        this.data.set(9 + id, newValue ? 1 : 0);
        if (id == 1 && newValue) {
            this.data.set(11, 0);
        } else if (id == 2 && newValue) {
            this.data.set(10, 0);
        }
        return true;
    }
}

